% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAP.R
\name{MAP}
\alias{MAP}
\title{Minimum Average Partial (MAP) Test}
\usage{
MAP(
  response,
  fa = "pc",
  nfact.max = 10,
  cor.type = "pearson",
  use = "pairwise.complete.obs",
  vis = TRUE,
  plot = TRUE
)
}
\arguments{
\item{response}{A required \code{N} × \code{I} matrix or data.frame consisting of the responses
of \code{N} individuals to \code{I} items.}

\item{fa}{A string that determines the method used to obtain factors loadings. If \code{"pc"}, it represents
Principal Component Analysis (PCA); if \code{"fa"}, it represents Maximun Likelihhod Estimation (a widely
used Factor Analysis method; @seealso \code{\link[psych]{fa}};
Auerswald & Moshagen, 2019). (Default = \code{"pc"})}

\item{nfact.max}{The maximum number of factors discussed by MAP. (default = 10)}

\item{cor.type}{A character string indicating which correlation coefficient (or covariance) is
to be computed. One of \code{"pearson"} (default), \code{"kendall"}, or
\code{"spearman"}. @seealso \code{\link[stats]{cor}}.}

\item{use}{an optional character string giving a method for computing covariances in the presence of missing values. This
must be one of the strings \code{"everything"}, \code{"all.obs"}, \code{"complete.obs"}, \code{"na.or.complete"},
or \code{"pairwise.complete.obs"} (default). @seealso \code{\link[stats]{cor}}.}

\item{vis}{A Boolean variable that will print the factor retention results when set to \code{TRUE}, and will not print
when set to \code{FALSE}. (default = \code{TRUE})}

\item{plot}{A Boolean variable that will print the MAP plot when set to \code{TRUE}, and will not print it when set to
\code{FALSE}. @seealso \code{\link[EFAfactors]{plot.MAP}}. (Default = \code{TRUE})}
}
\value{
An object of class \code{MAP}, which is a \code{list} containing the following components:
\item{nfact}{The number of factors to retain by both Optimal Coordinate and PA.}
\item{MAP.values}{the averaged squared partial correlations for 1 to \code{nfact.max} factors.}
}
\description{
The MAP test by Velicer (1976)was originally designed for
determining the number of components in PCA but is used in EFA as well.
At it score, the averaged partial correlations after excluding the
variance that can be explained by the previous components are compared among
different solutions and the one with the smallest value is chosen (therefore, MAP test).
}
\examples{
library(EFAfactors)
set.seed(123)

##Take the data.bfi dataset as an example.
data(data.bfi)

response <- as.matrix(data.bfi[, 1:25]) ## loading data
response <- na.omit(response) ## Remove samples with NA/missing values

## Transform the scores of reverse-scored items to normal scoring
response[, c(1, 9, 10, 11, 12, 22, 25)] <- 6 - response[, c(1, 9, 10, 11, 12, 22, 25)] + 1

\donttest{
 MAP.obj <- MAP(response, plot=FALSE)

 ## MAP plot
 plot(MAP.obj)

}

}
\references{
Velicer, W. F. (1976). Determining the number of components from the matrix of partial correlations. Psychometrika, 41(3), 321–327. https://doi.org/10.1007/BF02293557

 Goretzko, D. (2025). How many factors to retain in exploratory factor analysis? A critical overview of factor retention methods. Psychological methods, Advance online publication. https://doi.org/10.1037/met0000733
}
\seealso{
\code{\link[EFAfactors]{MAP}}
}
