#include <R.h>
#include "Rmath.h"
 extern "C" {
 void chebyshev_t_polynomials(double *xin, int *xlen, int *degree) {
 double x;
 switch(degree[0]) {
  case 0:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1e+00;
    }
    break;
  case 1:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1e+00*x;
    }
    break;
  case 2:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1e+00 + 2e+00*R_pow(x, 2.0);
    }
    break;
  case 3:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -3e+00*x + 4e+00*R_pow(x, 3.0);
    }
    break;
  case 4:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1e+00 - 8e+00*R_pow(x, 2.0) + 8e+00*R_pow(x, 4.0);
    }
    break;
  case 5:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 5.0e+00*x - 2.0e+01*R_pow(x, 3.0) + 1.6e+01*R_pow(x, 5.0);
    }
    break;
  case 6:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.0e+00 + 1.8e+01*R_pow(x, 2.0) - 4.8e+01*R_pow(x, 4.0) + 3.2e+01*R_pow(x, 6.0);
    }
    break;
  case 7:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -7.00e+00*x + 5.60e+01*R_pow(x, 3.0) - 1.12e+02*R_pow(x, 5.0) + 6.40e+01*R_pow(x, 7.0);
    }
    break;
  case 8:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.00e+00 - 3.20e+01*R_pow(x, 2.0) + 1.60e+02*R_pow(x, 4.0) - 2.56e+02*R_pow(x, 6.0) + 1.28e+02*R_pow(x, 8.0);
    }
    break;
  case 9:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 9.00e+00*x - 1.20e+02*R_pow(x, 3.0) + 4.32e+02*R_pow(x, 5.0) - 5.76e+02*R_pow(x, 7.0) + 2.56e+02*R_pow(x, 9.0);
    }
    break;
  case 10:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.00e+00 + 5.00e+01*R_pow(x, 2.0) - 4.00e+02*R_pow(x, 4.0) + 1.12e+03*R_pow(x, 6.0) - 1.28e+03*R_pow(x, 8.0) + 5.12e+02*R_pow(x, 10.0);
    }
    break;
  case 11:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.100e+01*x + 2.200e+02*R_pow(x, 3.0) - 1.232e+03*R_pow(x, 5.0) + 2.816e+03*R_pow(x, 7.0) - 2.816e+03*R_pow(x, 9.0) + 1.024e+03*R_pow(x, 11.0);
    }
    break;
  case 12:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000e+00 - 7.200e+01*R_pow(x, 2.0) + 8.400e+02*R_pow(x, 4.0) - 3.584e+03*R_pow(x, 6.0) + 6.912e+03*R_pow(x, 8.0) - 6.144e+03*R_pow(x, 10.0) + 2.048e+03*R_pow(x, 12.0);
    }
    break;
  case 13:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.3000e+01*x - 3.6400e+02*R_pow(x, 3.0) + 2.9120e+03*R_pow(x, 5.0) - 9.9840e+03*R_pow(x, 7.0) + 1.6640e+04*R_pow(x, 9.0) - 1.3312e+04*R_pow(x, 11.0) + 4.0960e+03*R_pow(x, 13.0);
    }
    break;
  case 14:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.0000e+00 + 9.8000e+01*R_pow(x, 2.0) - 1.5680e+03*R_pow(x, 4.0) + 9.4080e+03*R_pow(x, 6.0) - 2.6880e+04*R_pow(x, 8.0) + 3.9424e+04*R_pow(x, 10.0) - 2.8672e+04*R_pow(x, 12.0) + 8.1920e+03*R_pow(x, 14.0);
    }
    break;
  case 15:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.5000e+01*x + 5.6000e+02*R_pow(x, 3.0) - 6.0480e+03*R_pow(x, 5.0) + 2.8800e+04*R_pow(x, 7.0) - 7.0400e+04*R_pow(x, 9.0) + 9.2160e+04*R_pow(x, 11.0) - 6.1440e+04*R_pow(x, 13.0) + 1.6384e+04*R_pow(x, 15.0);
    }
    break;
  case 16:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.00000e+00 - 1.28000e+02*R_pow(x, 2.0) + 2.68800e+03*R_pow(x, 4.0) - 2.15040e+04*R_pow(x, 6.0) + 8.44800e+04*R_pow(x, 8.0) - 1.80224e+05*R_pow(x, 10.0) + 2.12992e+05*R_pow(x, 12.0) - 1.31072e+05*R_pow(x, 14.0) + 3.27680e+04*R_pow(x, 16.0);
    }
    break;
  case 17:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.70000e+01*x - 8.16000e+02*R_pow(x, 3.0) + 1.14240e+04*R_pow(x, 5.0) - 7.18080e+04*R_pow(x, 7.0) + 2.39360e+05*R_pow(x, 9.0) - 4.52608e+05*R_pow(x, 11.0) + 4.87424e+05*R_pow(x, 13.0) - 2.78528e+05*R_pow(x, 15.0) + 6.55360e+04*R_pow(x, 17.0);
    }
    break;
  case 18:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 1.620000e+02*R_pow(x, 2.0) - 4.320000e+03*R_pow(x, 4.0) + 4.435200e+04*R_pow(x, 6.0) - 2.280960e+05*R_pow(x, 8.0) + 6.589440e+05*R_pow(x, 10.0) - 1.118208e+06*R_pow(x, 12.0) + 1.105920e+06*R_pow(x, 14.0) - 5.898240e+05*R_pow(x, 16.0) + 1.310720e+05*R_pow(x, 18.0);
    }
    break;
  case 19:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.900000e+01*x + 1.140000e+03*R_pow(x, 3.0) - 2.006400e+04*R_pow(x, 5.0) + 1.605120e+05*R_pow(x, 7.0) - 6.955520e+05*R_pow(x, 9.0) + 1.770496e+06*R_pow(x, 11.0) - 2.723840e+06*R_pow(x, 13.0) + 2.490368e+06*R_pow(x, 15.0) - 1.245184e+06*R_pow(x, 17.0) + 2.621440e+05*R_pow(x, 19.0);
    }
    break;
  case 20:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 2.000000e+02*R_pow(x, 2.0) + 6.600000e+03*R_pow(x, 4.0) - 8.448000e+04*R_pow(x, 6.0) + 5.491200e+05*R_pow(x, 8.0) - 2.050048e+06*R_pow(x, 10.0) + 4.659200e+06*R_pow(x, 12.0) - 6.553600e+06*R_pow(x, 14.0) + 5.570560e+06*R_pow(x, 16.0) - 2.621440e+06*R_pow(x, 18.0) + 5.242880e+05*R_pow(x, 20.0);
    }
    break;
  case 21:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 2.100000e+01*x - 1.540000e+03*R_pow(x, 3.0) + 3.326400e+04*R_pow(x, 5.0) - 3.294720e+05*R_pow(x, 7.0) + 1.793792e+06*R_pow(x, 9.0) - 5.870592e+06*R_pow(x, 11.0) + 1.204224e+07*R_pow(x, 13.0) - 1.559757e+07*R_pow(x, 15.0) + 1.238630e+07*R_pow(x, 17.0) - 5.505024e+06*R_pow(x, 19.0) + 1.048576e+06*R_pow(x, 21.0);
    }
    break;
  case 22:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 2.420000e+02*R_pow(x, 2.0) - 9.680000e+03*R_pow(x, 4.0) + 1.510080e+05*R_pow(x, 6.0) - 1.208064e+06*R_pow(x, 8.0) + 5.637632e+06*R_pow(x, 10.0) - 1.640038e+07*R_pow(x, 12.0) + 3.063808e+07*R_pow(x, 14.0) - 3.676570e+07*R_pow(x, 16.0) + 2.739405e+07*R_pow(x, 18.0) - 1.153434e+07*R_pow(x, 20.0) + 2.097152e+06*R_pow(x, 22.0);
    }
    break;
  case 23:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -2.300000e+01*x + 2.024000e+03*R_pow(x, 3.0) - 5.262400e+04*R_pow(x, 5.0) + 6.314880e+05*R_pow(x, 7.0) - 4.209920e+06*R_pow(x, 9.0) + 1.714586e+07*R_pow(x, 11.0) - 4.484301e+07*R_pow(x, 13.0) + 7.687373e+07*R_pow(x, 15.0) - 8.591770e+07*R_pow(x, 17.0) + 6.029312e+07*R_pow(x, 19.0) - 2.411725e+07*R_pow(x, 21.0) + 4.194304e+06*R_pow(x, 23.0);
    }
    break;
  case 24:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 2.880000e+02*R_pow(x, 2.0) + 1.372800e+04*R_pow(x, 4.0) - 2.562560e+05*R_pow(x, 6.0) + 2.471040e+06*R_pow(x, 8.0) - 1.405747e+07*R_pow(x, 10.0) + 5.069210e+07*R_pow(x, 12.0) - 1.203241e+08*R_pow(x, 14.0) + 1.905132e+08*R_pow(x, 16.0) - 1.992294e+08*R_pow(x, 18.0) + 1.321206e+08*R_pow(x, 20.0) - 5.033165e+07*R_pow(x, 22.0) + 8.388608e+06*R_pow(x, 24.0);
    }
    break;
  case 25:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 2.500000e+01*x - 2.600000e+03*R_pow(x, 3.0) + 8.008000e+04*R_pow(x, 5.0) - 1.144000e+06*R_pow(x, 7.0) + 9.152000e+06*R_pow(x, 9.0) - 4.526080e+07*R_pow(x, 11.0) + 1.462272e+08*R_pow(x, 13.0) - 3.175219e+08*R_pow(x, 15.0) + 4.669440e+08*R_pow(x, 17.0) - 4.587520e+08*R_pow(x, 19.0) + 2.883584e+08*R_pow(x, 21.0) - 1.048576e+08*R_pow(x, 23.0) + 1.677722e+07*R_pow(x, 25.0);
    }
    break;
  case 26:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 3.380000e+02*R_pow(x, 2.0) - 1.892800e+04*R_pow(x, 4.0) + 4.164160e+05*R_pow(x, 6.0) - 4.759040e+06*R_pow(x, 8.0) + 3.236147e+07*R_pow(x, 10.0) - 1.412137e+08*R_pow(x, 12.0) + 4.127785e+08*R_pow(x, 14.0) - 8.255570e+08*R_pow(x, 16.0) + 1.133117e+09*R_pow(x, 18.0) - 1.049625e+09*R_pow(x, 20.0) + 6.270484e+08*R_pow(x, 22.0) - 2.181038e+08*R_pow(x, 24.0) + 3.355443e+07*R_pow(x, 26.0);
    }
    break;
  case 27:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -2.700000e+01*x + 3.276000e+03*R_pow(x, 3.0) - 1.179360e+05*R_pow(x, 5.0) + 1.976832e+06*R_pow(x, 7.0) - 1.867008e+07*R_pow(x, 9.0) + 1.099837e+08*R_pow(x, 11.0) - 4.286546e+08*R_pow(x, 13.0) + 1.143079e+09*R_pow(x, 15.0) - 2.118058e+09*R_pow(x, 17.0) + 2.724987e+09*R_pow(x, 19.0) - 2.387608e+09*R_pow(x, 21.0) + 1.358954e+09*R_pow(x, 23.0) - 4.529848e+08*R_pow(x, 25.0) + 6.710886e+07*R_pow(x, 27.0);
    }
    break;
  case 28:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 3.920000e+02*R_pow(x, 2.0) + 2.548000e+04*R_pow(x, 4.0) - 6.522880e+05*R_pow(x, 6.0) + 8.712704e+06*R_pow(x, 8.0) - 6.970163e+07*R_pow(x, 10.0) + 3.611812e+08*R_pow(x, 12.0) - 1.270088e+09*R_pow(x, 14.0) + 3.111715e+09*R_pow(x, 16.0) - 5.369233e+09*R_pow(x, 18.0) + 6.499598e+09*R_pow(x, 20.0) - 5.402264e+09*R_pow(x, 22.0) + 2.936013e+09*R_pow(x, 24.0) - 9.395241e+08*R_pow(x, 26.0) + 1.342177e+08*R_pow(x, 28.0);
    }
    break;
  case 29:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 2.900000e+01*x - 4.060000e+03*R_pow(x, 3.0) + 1.688960e+05*R_pow(x, 5.0) - 3.281408e+06*R_pow(x, 7.0) + 3.609549e+07*R_pow(x, 9.0) - 2.493870e+08*R_pow(x, 11.0) + 1.151017e+09*R_pow(x, 13.0) - 3.683254e+09*R_pow(x, 15.0) + 8.341488e+09*R_pow(x, 17.0) - 1.346345e+10*R_pow(x, 19.0) + 1.538680e+10*R_pow(x, 21.0) - 1.216348e+10*R_pow(x, 23.0) + 6.325010e+09*R_pow(x, 25.0) - 1.946157e+09*R_pow(x, 27.0) + 2.684355e+08*R_pow(x, 29.0);
    }
    break;
  case 30:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 4.500000e+02*R_pow(x, 2.0) - 3.360000e+04*R_pow(x, 4.0) + 9.900800e+05*R_pow(x, 6.0) - 1.527552e+07*R_pow(x, 8.0) + 1.418926e+08*R_pow(x, 10.0) - 8.599552e+08*R_pow(x, 12.0) + 3.572122e+09*R_pow(x, 14.0) - 1.047822e+10*R_pow(x, 16.0) + 2.205221e+10*R_pow(x, 18.0) - 3.342651e+10*R_pow(x, 20.0) + 3.617587e+10*R_pow(x, 22.0) - 2.726298e+10*R_pow(x, 24.0) + 1.358954e+10*R_pow(x, 26.0) - 4.026532e+09*R_pow(x, 28.0) + 5.368709e+08*R_pow(x, 30.0);
    }
    break;
  case 31:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -3.100000e+01*x + 4.960000e+03*R_pow(x, 3.0) - 2.360960e+05*R_pow(x, 5.0) + 5.261568e+06*R_pow(x, 7.0) - 6.664653e+07*R_pow(x, 9.0) + 5.331722e+08*R_pow(x, 11.0) - 2.870927e+09*R_pow(x, 13.0) + 1.082750e+10*R_pow(x, 15.0) - 2.929793e+10*R_pow(x, 17.0) + 5.756787e+10*R_pow(x, 19.0) - 8.223982e+10*R_pow(x, 21.0) + 8.451523e+10*R_pow(x, 23.0) - 6.085096e+10*R_pow(x, 25.0) + 2.912525e+10*R_pow(x, 27.0) - 8.321499e+09*R_pow(x, 29.0) + 1.073742e+09*R_pow(x, 31.0);
    }
    break;
  case 32:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 5.120000e+02*R_pow(x, 2.0) + 4.352000e+04*R_pow(x, 4.0) - 1.462272e+06*R_pow(x, 6.0) + 2.579866e+07*R_pow(x, 8.0) - 2.751857e+08*R_pow(x, 10.0) + 1.926300e+09*R_pow(x, 12.0) - 9.313976e+09*R_pow(x, 14.0) + 3.213322e+10*R_pow(x, 16.0) - 8.064808e+10*R_pow(x, 18.0) + 1.485622e+11*R_pow(x, 20.0) - 2.006555e+11*R_pow(x, 22.0) + 1.962934e+11*R_pow(x, 24.0) - 1.352915e+11*R_pow(x, 26.0) + 6.227703e+10*R_pow(x, 28.0) - 1.717987e+10*R_pow(x, 30.0) + 2.147484e+09*R_pow(x, 32.0);
    }
    break;
  case 33:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 3.300000e+01*x - 5.984000e+03*R_pow(x, 3.0) + 3.231360e+05*R_pow(x, 5.0) - 8.186112e+06*R_pow(x, 7.0) + 1.182438e+08*R_pow(x, 9.0) - 1.083544e+09*R_pow(x, 11.0) + 6.723527e+09*R_pow(x, 13.0) - 2.945545e+10*R_pow(x, 15.0) + 9.356437e+10*R_pow(x, 17.0) - 2.188640e+11*R_pow(x, 19.0) + 3.793643e+11*R_pow(x, 21.0) - 4.858262e+11*R_pow(x, 23.0) + 4.534378e+11*R_pow(x, 25.0) - 2.997082e+11*R_pow(x, 27.0) + 1.328756e+11*R_pow(x, 29.0) - 3.543348e+10*R_pow(x, 31.0) + 4.294967e+09*R_pow(x, 33.0);
    }
    break;
  case 34:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 5.780000e+02*R_pow(x, 2.0) - 5.548800e+04*R_pow(x, 4.0) + 2.108544e+06*R_pow(x, 6.0) - 4.217088e+07*R_pow(x, 8.0) + 5.116733e+08*R_pow(x, 10.0) - 4.093387e+09*R_pow(x, 12.0) + 2.276103e+10*R_pow(x, 14.0) - 9.104412e+10*R_pow(x, 16.0) + 2.677768e+11*R_pow(x, 18.0) - 5.862903e+11*R_pow(x, 20.0) + 9.593841e+11*R_pow(x, 22.0) - 1.167946e+12*R_pow(x, 24.0) + 1.042167e+12*R_pow(x, 26.0) - 6.616934e+11*R_pow(x, 28.0) + 2.829310e+11*R_pow(x, 30.0) - 7.301444e+10*R_pow(x, 32.0) + 8.589935e+09*R_pow(x, 34.0);
    }
    break;
  case 35:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -3.500000e+01*x + 7.140000e+03*R_pow(x, 3.0) - 4.341120e+05*R_pow(x, 5.0) + 1.240320e+07*R_pow(x, 7.0) - 2.025856e+08*R_pow(x, 9.0) + 2.106890e+09*R_pow(x, 11.0) - 1.491030e+10*R_pow(x, 13.0) + 7.497751e+10*R_pow(x, 15.0) - 2.756526e+11*R_pow(x, 17.0) + 7.544177e+11*R_pow(x, 19.0) - 1.551945e+12*R_pow(x, 21.0) + 2.404594e+12*R_pow(x, 23.0) - 2.789330e+12*R_pow(x, 25.0) + 2.384042e+12*R_pow(x, 27.0) - 1.456262e+12*R_pow(x, 29.0) + 6.012954e+11*R_pow(x, 31.0) - 1.503239e+11*R_pow(x, 33.0) + 1.717987e+10*R_pow(x, 35.0);
    }
    break;
  case 36:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 6.480000e+02*R_pow(x, 2.0) + 6.976800e+04*R_pow(x, 4.0) - 2.976768e+06*R_pow(x, 6.0) + 6.697728e+07*R_pow(x, 8.0) - 9.168445e+08*R_pow(x, 10.0) + 8.307167e+09*R_pow(x, 12.0) - 5.258163e+10*R_pow(x, 14.0) + 2.409991e+11*R_pow(x, 16.0) - 8.190820e+11*R_pow(x, 18.0) + 2.095126e+12*R_pow(x, 20.0) - 4.063274e+12*R_pow(x, 22.0) + 5.977135e+12*R_pow(x, 24.0) - 6.620826e+12*R_pow(x, 26.0) + 5.429778e+12*R_pow(x, 28.0) - 3.195456e+12*R_pow(x, 30.0) + 1.275605e+12*R_pow(x, 32.0) - 3.092376e+11*R_pow(x, 34.0) + 3.435974e+10*R_pow(x, 36.0);
    }
    break;
  case 37:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 3.700000e+01*x - 8.436000e+03*R_pow(x, 3.0) + 5.736480e+05*R_pow(x, 5.0) - 1.835674e+07*R_pow(x, 7.0) + 3.365402e+08*R_pow(x, 9.0) - 3.940579e+09*R_pow(x, 11.0) + 3.152463e+10*R_pow(x, 13.0) - 1.801408e+11*R_pow(x, 15.0) + 7.576509e+11*R_pow(x, 17.0) - 2.392582e+12*R_pow(x, 19.0) + 5.742196e+12*R_pow(x, 21.0) - 1.053114e+13*R_pow(x, 23.0) + 1.474360e+13*R_pow(x, 25.0) - 1.562570e+13*R_pow(x, 27.0) + 1.231582e+13*R_pow(x, 29.0) - 6.992207e+12*R_pow(x, 31.0) + 2.701534e+12*R_pow(x, 33.0) - 6.356552e+11*R_pow(x, 35.0) + 6.871948e+10*R_pow(x, 37.0);
    }
    break;
  case 38:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 7.220000e+02*R_pow(x, 2.0) - 8.664000e+04*R_pow(x, 4.0) + 4.124064e+06*R_pow(x, 6.0) - 1.036908e+08*R_pow(x, 8.0) + 1.589925e+09*R_pow(x, 10.0) - 1.618833e+10*R_pow(x, 12.0) + 1.156309e+11*R_pow(x, 14.0) - 6.012807e+11*R_pow(x, 16.0) + 2.334384e+12*R_pow(x, 18.0) - 6.880289e+12*R_pow(x, 20.0) + 1.554767e+13*R_pow(x, 22.0) - 2.703942e+13*R_pow(x, 24.0) + 3.610802e+13*R_pow(x, 26.0) - 3.668117e+13*R_pow(x, 28.0) + 2.782709e+13*R_pow(x, 30.0) - 1.526002e+13*R_pow(x, 32.0) + 5.712307e+12*R_pow(x, 34.0) - 1.305670e+12*R_pow(x, 36.0) + 1.374390e+11*R_pow(x, 38.0);
    }
    break;
  case 39:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -3.900000e+01*x + 9.880000e+03*R_pow(x, 3.0) - 7.469280e+05*R_pow(x, 5.0) + 2.660486e+07*R_pow(x, 7.0) - 5.439217e+08*R_pow(x, 9.0) + 7.120429e+09*R_pow(x, 11.0) - 6.390129e+10*R_pow(x, 13.0) + 4.114026e+11*R_pow(x, 15.0) - 1.960212e+12*R_pow(x, 17.0) + 7.061349e+12*R_pow(x, 19.0) - 1.950277e+13*R_pow(x, 21.0) + 4.162647e+13*R_pow(x, 23.0) - 6.882244e+13*R_pow(x, 25.0) + 8.784174e+13*R_pow(x, 27.0) - 8.567816e+13*R_pow(x, 29.0) + 6.264639e+13*R_pow(x, 31.0) - 3.322157e+13*R_pow(x, 33.0) + 1.206027e+13*R_pow(x, 35.0) - 2.680060e+12*R_pow(x, 37.0) + 2.748779e+11*R_pow(x, 39.0);
    }
    break;
  case 40:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 8.000000e+02*R_pow(x, 2.0) + 1.064000e+05*R_pow(x, 4.0) - 5.617920e+06*R_pow(x, 6.0) + 1.569005e+08*R_pow(x, 8.0) - 2.677768e+09*R_pow(x, 10.0) + 3.042918e+10*R_pow(x, 12.0) - 2.434335e+11*R_pow(x, 14.0) + 1.424086e+12*R_pow(x, 16.0) - 6.254808e+12*R_pow(x, 18.0) + 2.100299e+13*R_pow(x, 20.0) - 5.455321e+13*R_pow(x, 22.0) + 1.102924e+14*R_pow(x, 24.0) - 1.737529e+14*R_pow(x, 26.0) + 2.123647e+14*R_pow(x, 28.0) - 1.991834e+14*R_pow(x, 30.0) + 1.405528e+14*R_pow(x, 32.0) - 7.215545e+13*R_pow(x, 34.0) + 2.542621e+13*R_pow(x, 36.0) - 5.497558e+12*R_pow(x, 38.0) + 5.497558e+11*R_pow(x, 40.0);
    }
    break;
  case 41:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 4.100000e+01*x - 1.148000e+04*R_pow(x, 3.0) + 9.597280e+05*R_pow(x, 5.0) - 3.784070e+07*R_pow(x, 7.0) + 8.577226e+08*R_pow(x, 9.0) - 1.247597e+10*R_pow(x, 11.0) + 1.247597e+11*R_pow(x, 13.0) - 8.982695e+11*R_pow(x, 15.0) + 4.808384e+12*R_pow(x, 17.0) - 1.957097e+13*R_pow(x, 19.0) + 6.150875e+13*R_pow(x, 21.0) - 1.507329e+14*R_pow(x, 23.0) + 2.894072e+14*R_pow(x, 25.0) - 4.353475e+14*R_pow(x, 27.0) + 5.104075e+14*R_pow(x, 29.0) - 4.610132e+14*R_pow(x, 31.0) + 3.143272e+14*R_pow(x, 33.0) - 1.563712e+14*R_pow(x, 35.0) + 5.353247e+13*R_pow(x, 37.0) - 1.126999e+13*R_pow(x, 39.0) + 1.099512e+12*R_pow(x, 41.0);
    }
    break;
  case 42:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 8.820000e+02*R_pow(x, 2.0) - 1.293600e+05*R_pow(x, 4.0) + 7.537376e+06*R_pow(x, 6.0) - 2.325819e+08*R_pow(x, 8.0) + 4.393213e+09*R_pow(x, 10.0) - 5.538111e+10*R_pow(x, 12.0) + 4.929528e+11*R_pow(x, 14.0) - 3.220625e+12*R_pow(x, 16.0) + 1.587158e+13*R_pow(x, 18.0) - 6.014492e+13*R_pow(x, 20.0) + 1.775707e+14*R_pow(x, 22.0) - 4.117582e+14*R_pow(x, 24.0) + 7.525673e+14*R_pow(x, 26.0) - 1.083060e+15*R_pow(x, 28.0) + 1.219998e+15*R_pow(x, 30.0) - 1.062579e+15*R_pow(x, 32.0) + 7.008098e+14*R_pow(x, 34.0) - 3.381685e+14*R_pow(x, 36.0) + 1.125625e+14*R_pow(x, 38.0) - 2.308974e+13*R_pow(x, 40.0) + 2.199023e+12*R_pow(x, 42.0);
    }
    break;
  case 43:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -4.300000e+01*x + 1.324400e+04*R_pow(x, 3.0) - 1.218448e+06*R_pow(x, 5.0) + 5.291546e+07*R_pow(x, 7.0) - 1.322886e+09*R_pow(x, 9.0) + 2.126239e+10*R_pow(x, 11.0) - 2.355219e+11*R_pow(x, 13.0) + 1.884175e+12*R_pow(x, 15.0) - 1.124963e+13*R_pow(x, 17.0) + 5.131412e+13*R_pow(x, 19.0) - 1.817986e+14*R_pow(x, 21.0) + 5.058743e+14*R_pow(x, 23.0) - 1.112924e+15*R_pow(x, 25.0) + 1.940482e+15*R_pow(x, 27.0) - 2.676527e+15*R_pow(x, 29.0) + 2.901010e+15*R_pow(x, 31.0) - 2.439486e+15*R_pow(x, 33.0) + 1.557991e+15*R_pow(x, 35.0) - 7.298696e+14*R_pow(x, 37.0) + 2.363950e+14*R_pow(x, 39.0) - 4.727900e+13*R_pow(x, 41.0) + 4.398047e+12*R_pow(x, 43.0);
    }
    break;
  case 44:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 9.680000e+02*R_pow(x, 2.0) + 1.558480e+05*R_pow(x, 4.0) - 9.974272e+06*R_pow(x, 6.0) + 3.384128e+08*R_pow(x, 8.0) - 7.038986e+09*R_pow(x, 10.0) + 9.790590e+10*R_pow(x, 12.0) - 9.639965e+11*R_pow(x, 14.0) + 6.988975e+12*R_pow(x, 16.0) - 3.837084e+13*R_pow(x, 18.0) + 1.627732e+14*R_pow(x, 20.0) - 5.411679e+14*R_pow(x, 22.0) + 1.423507e+15*R_pow(x, 24.0) - 2.978414e+15*R_pow(x, 26.0) + 4.964024e+15*R_pow(x, 28.0) - 6.573052e+15*R_pow(x, 30.0) + 6.864599e+15*R_pow(x, 32.0) - 5.579781e+15*R_pow(x, 34.0) + 3.454150e+15*R_pow(x, 36.0) - 1.572302e+15*R_pow(x, 38.0) + 4.958797e+14*R_pow(x, 40.0) - 9.675702e+13*R_pow(x, 42.0) + 8.796093e+12*R_pow(x, 44.0);
    }
    break;
  case 45:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 4.500000e+01*x - 1.518000e+04*R_pow(x, 3.0) + 1.530144e+06*R_pow(x, 5.0) - 7.286400e+07*R_pow(x, 7.0) + 1.999712e+09*R_pow(x, 9.0) - 3.534036e+10*R_pow(x, 11.0) + 4.313337e+11*R_pow(x, 13.0) - 3.812168e+12*R_pow(x, 15.0) + 2.522758e+13*R_pow(x, 17.0) - 1.280558e+14*R_pow(x, 19.0) + 5.073449e+14*R_pow(x, 21.0) - 1.588210e+15*R_pow(x, 23.0) + 3.959937e+15*R_pow(x, 25.0) - 7.897311e+15*R_pow(x, 27.0) + 1.260457e+16*R_pow(x, 29.0) - 1.604711e+16*R_pow(x, 31.0) + 1.616868e+16*R_pow(x, 33.0) - 1.271755e+16*R_pow(x, 35.0) + 7.638170e+15*R_pow(x, 37.0) - 3.380998e+15*R_pow(x, 39.0) + 1.039038e+15*R_pow(x, 41.0) - 1.979121e+14*R_pow(x, 43.0) + 1.759219e+13*R_pow(x, 45.0);
    }
    break;
  case 46:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 1.058000e+03*R_pow(x, 2.0) - 1.862080e+05*R_pow(x, 4.0) + 1.303456e+07*R_pow(x, 6.0) - 4.841408e+08*R_pow(x, 8.0) + 1.103841e+10*R_pow(x, 10.0) - 1.685866e+11*R_pow(x, 12.0) + 1.826664e+12*R_pow(x, 14.0) - 1.461331e+13*R_pow(x, 16.0) + 8.882601e+13*R_pow(x, 18.0) - 4.188848e+14*R_pow(x, 20.0) + 1.555858e+15*R_pow(x, 22.0) - 4.599927e+15*R_pow(x, 24.0) + 1.089829e+16*R_pow(x, 26.0) - 2.075865e+16*R_pow(x, 28.0) + 3.178220e+16*R_pow(x, 30.0) - 3.895883e+16*R_pow(x, 32.0) + 3.791715e+16*R_pow(x, 34.0) - 2.888926e+16*R_pow(x, 36.0) + 1.684864e+16*R_pow(x, 38.0) - 7.257876e+15*R_pow(x, 40.0) + 2.174834e+15*R_pow(x, 42.0) - 4.046203e+14*R_pow(x, 44.0) + 3.518437e+13*R_pow(x, 46.0);
    }
    break;
  case 47:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -4.700000e+01*x + 1.729600e+04*R_pow(x, 3.0) - 1.902560e+06*R_pow(x, 5.0) + 9.893312e+07*R_pow(x, 7.0) - 2.967994e+09*R_pow(x, 9.0) + 5.741719e+10*R_pow(x, 11.0) - 7.685069e+11*R_pow(x, 13.0) + 7.465496e+12*R_pow(x, 15.0) - 5.445421e+13*R_pow(x, 17.0) + 3.057078e+14*R_pow(x, 19.0) - 1.345114e+15*R_pow(x, 21.0) + 4.699926e+15*R_pow(x, 23.0) - 1.315979e+16*R_pow(x, 25.0) + 2.969389e+16*R_pow(x, 27.0) - 5.412187e+16*R_pow(x, 29.0) + 7.961152e+16*R_pow(x, 31.0) - 9.408634e+16*R_pow(x, 33.0) + 8.855185e+16*R_pow(x, 35.0) - 6.541668e+16*R_pow(x, 37.0) + 3.707828e+16*R_pow(x, 39.0) - 1.555479e+16*R_pow(x, 41.0) + 4.547580e+15*R_pow(x, 43.0) - 8.268327e+14*R_pow(x, 45.0) + 7.036874e+13*R_pow(x, 47.0);
    }
    break;
  case 48:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 1.152000e+03*R_pow(x, 2.0) + 2.208000e+05*R_pow(x, 4.0) - 1.683968e+07*R_pow(x, 6.0) + 6.820070e+08*R_pow(x, 8.0) - 1.697440e+10*R_pow(x, 10.0) + 2.834210e+11*R_pow(x, 12.0) - 3.363678e+12*R_pow(x, 14.0) + 2.954430e+13*R_pow(x, 16.0) - 1.977344e+14*R_pow(x, 18.0) + 1.030300e+15*R_pow(x, 20.0) - 4.246087e+15*R_pow(x, 22.0) + 1.399978e+16*R_pow(x, 24.0) - 3.721787e+16*R_pow(x, 26.0) + 8.014642e+16*R_pow(x, 28.0) - 1.400259e+17*R_pow(x, 30.0) + 1.981819e+17*R_pow(x, 32.0) - 2.260898e+17*R_pow(x, 34.0) + 2.059930e+17*R_pow(x, 36.0) - 1.476820e+17*R_pow(x, 38.0) + 8.141444e+16*R_pow(x, 40.0) - 3.328442e+16*R_pow(x, 42.0) + 9.499780e+15*R_pow(x, 44.0) - 1.688850e+15*R_pow(x, 46.0) + 1.407375e+14*R_pow(x, 48.0);
    }
    break;
  case 49:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 4.900000e+01*x - 1.960000e+04*R_pow(x, 3.0) + 2.344160e+06*R_pow(x, 5.0) - 1.326125e+08*R_pow(x, 7.0) + 4.332008e+09*R_pow(x, 9.0) - 9.136598e+10*R_pow(x, 11.0) + 1.335349e+12*R_pow(x, 13.0) - 1.419285e+13*R_pow(x, 15.0) + 1.135428e+14*R_pow(x, 17.0) - 7.011767e+14*R_pow(x, 19.0) + 3.405715e+15*R_pow(x, 21.0) - 1.319210e+16*R_pow(x, 23.0) + 4.115935e+16*R_pow(x, 25.0) - 1.041296e+17*R_pow(x, 27.0) + 2.144147e+17*R_pow(x, 29.0) - 3.596634e+17*R_pow(x, 31.0) + 4.904501e+17*R_pow(x, 33.0) - 5.407315e+17*R_pow(x, 35.0) + 4.774026e+17*R_pow(x, 37.0) - 3.324423e+17*R_pow(x, 39.0) + 1.783837e+17*R_pow(x, 41.0) - 7.111641e+16*R_pow(x, 43.0) + 1.982639e+16*R_pow(x, 45.0) - 3.448068e+15*R_pow(x, 47.0) + 2.814750e+14*R_pow(x, 49.0);
    }
    break;
  case 50:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 1.250000e+03*R_pow(x, 2.0) - 2.600000e+05*R_pow(x, 4.0) + 2.152800e+07*R_pow(x, 6.0) - 9.472320e+08*R_pow(x, 8.0) + 2.563841e+10*R_pow(x, 10.0) - 4.661530e+11*R_pow(x, 12.0) + 6.034376e+12*R_pow(x, 14.0) - 5.793001e+13*R_pow(x, 16.0) + 4.248200e+14*R_pow(x, 18.0) - 2.432654e+15*R_pow(x, 20.0) + 1.105752e+16*R_pow(x, 22.0) - 4.038398e+16*R_pow(x, 24.0) + 1.195366e+17*R_pow(x, 26.0) - 2.884057e+17*R_pow(x, 28.0) + 5.688554e+17*R_pow(x, 30.0) - 9.175086e+17*R_pow(x, 32.0) + 1.206990e+18*R_pow(x, 34.0) - 1.287456e+18*R_pow(x, 36.0) + 1.102487e+18*R_pow(x, 38.0) - 7.462990e+17*R_pow(x, 40.0) + 3.900517e+17*R_pow(x, 42.0) - 1.517326e+17*R_pow(x, 44.0) + 4.134164e+16*R_pow(x, 46.0) - 7.036874e+15*R_pow(x, 48.0) + 5.629500e+14*R_pow(x, 50.0);
    }
    break;
  case 51:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -5.100000e+01*x + 2.210000e+04*R_pow(x, 3.0) - 2.864160e+06*R_pow(x, 5.0) + 1.756685e+08*R_pow(x, 7.0) - 6.226472e+09*R_pow(x, 9.0) + 1.426428e+11*R_pow(x, 11.0) - 2.267655e+12*R_pow(x, 13.0) + 2.626160e+13*R_pow(x, 15.0) - 2.294028e+14*R_pow(x, 17.0) + 1.550817e+15*R_pow(x, 19.0) - 8.271023e+15*R_pow(x, 21.0) + 3.530713e+16*R_pow(x, 23.0) - 1.219273e+17*R_pow(x, 25.0) + 3.432028e+17*R_pow(x, 27.0) - 7.912261e+17*R_pow(x, 29.0) + 1.497374e+18*R_pow(x, 31.0) - 2.325467e+18*R_pow(x, 33.0) + 2.954711e+18*R_pow(x, 35.0) - 3.052315e+18*R_pow(x, 37.0) + 2.537417e+18*R_pow(x, 39.0) - 1.670982e+18*R_pow(x, 41.0) + 8.512199e+17*R_pow(x, 43.0) - 3.232916e+17*R_pow(x, 45.0) + 8.613134e+16*R_pow(x, 47.0) - 1.435522e+16*R_pow(x, 49.0) + 1.125900e+15*R_pow(x, 51.0);
    }
    break;
  case 52:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 1.352000e+03*R_pow(x, 2.0) + 3.042000e+05*R_pow(x, 4.0) - 2.725632e+07*R_pow(x, 6.0) + 1.298569e+09*R_pow(x, 8.0) - 3.809136e+10*R_pow(x, 10.0) + 7.514386e+11*R_pow(x, 12.0) - 1.056969e+13*R_pow(x, 14.0) + 1.104532e+14*R_pow(x, 16.0) - 8.836257e+14*R_pow(x, 18.0) + 5.534287e+15*R_pow(x, 20.0) - 2.759956e+16*R_pow(x, 22.0) + 1.109982e+17*R_pow(x, 24.0) - 3.633912e+17*R_pow(x, 26.0) + 9.748112e+17*R_pow(x, 28.0) - 2.151308e+18*R_pow(x, 30.0) + 3.912257e+18*R_pow(x, 32.0) - 5.857925e+18*R_pow(x, 34.0) + 7.196879e+18*R_pow(x, 36.0) - 7.207116e+18*R_pow(x, 38.0) + 5.821132e+18*R_pow(x, 40.0) - 3.732015e+18*R_pow(x, 42.0) + 1.854172e+18*R_pow(x, 44.0) - 6.879248e+17*R_pow(x, 46.0) + 1.792996e+17*R_pow(x, 48.0) - 2.927340e+16*R_pow(x, 50.0) + 2.251800e+15*R_pow(x, 52.0);
    }
    break;
  case 53:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 5.300000e+01*x - 2.480400e+04*R_pow(x, 3.0) + 3.472560e+06*R_pow(x, 5.0) - 2.301811e+08*R_pow(x, 7.0) + 8.823610e+09*R_pow(x, 9.0) - 2.188255e+11*R_pow(x, 11.0) + 3.770532e+12*R_pow(x, 13.0) - 4.740097e+13*R_pow(x, 15.0) + 4.503093e+14*R_pow(x, 17.0) - 3.318068e+15*R_pow(x, 19.0) + 1.933960e+16*R_pow(x, 21.0) - 9.050626e+16*R_pow(x, 23.0) + 3.439238e+17*R_pow(x, 25.0) - 1.069985e+18*R_pow(x, 27.0) + 2.740849e+18*R_pow(x, 29.0) - 5.799989e+18*R_pow(x, 31.0) + 1.014998e+19*R_pow(x, 33.0) - 1.467056e+19*R_pow(x, 35.0) + 1.744607e+19*R_pow(x, 37.0) - 1.695165e+19*R_pow(x, 39.0) + 1.331325e+19*R_pow(x, 41.0) - 8.315250e+18*R_pow(x, 43.0) + 4.031636e+18*R_pow(x, 45.0) - 1.461981e+18*R_pow(x, 47.0) + 3.729543e+17*R_pow(x, 49.0) - 5.967270e+16*R_pow(x, 51.0) + 4.503600e+15*R_pow(x, 53.0);
    }
    break;
  case 54:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 1.458000e+03*R_pow(x, 2.0) - 3.538080e+05*R_pow(x, 4.0) + 3.420144e+07*R_pow(x, 6.0) - 1.758931e+09*R_pow(x, 8.0) + 5.573858e+10*R_pow(x, 10.0) - 1.189090e+12*R_pow(x, 12.0) + 1.811075e+13*R_pow(x, 14.0) - 2.052552e+14*R_pow(x, 16.0) + 1.784244e+15*R_pow(x, 18.0) - 1.217042e+16*R_pow(x, 20.0) + 6.627876e+16*R_pow(x, 22.0) - 2.920108e+17*R_pow(x, 24.0) + 1.051239e+18*R_pow(x, 26.0) - 3.114781e+18*R_pow(x, 28.0) + 7.633005e+18*R_pow(x, 30.0) - 1.551224e+19*R_pow(x, 32.0) + 2.615789e+19*R_pow(x, 34.0) - 3.653800e+19*R_pow(x, 36.0) + 4.209926e+19*R_pow(x, 38.0) - 3.972443e+19*R_pow(x, 40.0) + 3.035851e+19*R_pow(x, 42.0) - 1.848467e+19*R_pow(x, 44.0) + 8.751198e+18*R_pow(x, 46.0) - 3.103262e+18*R_pow(x, 48.0) + 7.751821e+17*R_pow(x, 50.0) - 1.215972e+17*R_pow(x, 52.0) + 9.007199e+15*R_pow(x, 54.0);
    }
    break;
  case 55:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -5.500000e+01*x + 2.772000e+04*R_pow(x, 3.0) - 4.180176e+06*R_pow(x, 5.0) + 2.985840e+08*R_pow(x, 7.0) - 1.234147e+10*R_pow(x, 9.0) + 3.303027e+11*R_pow(x, 11.0) - 6.148711e+12*R_pow(x, 13.0) + 8.362247e+13*R_pow(x, 15.0) - 8.608196e+14*R_pow(x, 17.0) + 6.886557e+15*R_pow(x, 19.0) - 4.368044e+16*R_pow(x, 21.0) + 2.230638e+17*R_pow(x, 23.0) - 9.279453e+17*R_pow(x, 25.0) + 3.172463e+18*R_pow(x, 27.0) - 8.970411e+18*R_pow(x, 29.0) + 2.106600e+19*R_pow(x, 31.0) - 4.117445e+19*R_pow(x, 33.0) + 6.698633e+19*R_pow(x, 35.0) - 9.052207e+19*R_pow(x, 37.0) + 1.011502e+20*R_pow(x, 39.0) - 9.276211e+19*R_pow(x, 41.0) + 6.903227e+19*R_pow(x, 43.0) - 4.100098e+19*R_pow(x, 45.0) + 1.896438e+19*R_pow(x, 47.0) - 6.579478e+18*R_pow(x, 49.0) + 1.610037e+18*R_pow(x, 51.0) - 2.476980e+17*R_pow(x, 53.0) + 1.801440e+16*R_pow(x, 55.0);
    }
    break;
  case 56:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 1.568000e+03*R_pow(x, 2.0) + 4.092480e+05*R_pow(x, 4.0) - 4.256179e+07*R_pow(x, 6.0) + 2.356099e+09*R_pow(x, 8.0) - 8.042152e+10*R_pow(x, 10.0) + 1.849695e+12*R_pow(x, 12.0) - 3.040817e+13*R_pow(x, 14.0) + 3.725001e+14*R_pow(x, 16.0) - 3.505883e+15*R_pow(x, 18.0) + 2.594354e+16*R_pow(x, 20.0) - 1.536396e+17*R_pow(x, 22.0) + 7.381383e+17*R_pow(x, 24.0) - 2.907129e+18*R_pow(x, 26.0) + 9.459706e+18*R_pow(x, 28.0) - 2.557383e+19*R_pow(x, 30.0) + 5.764423e+19*R_pow(x, 32.0) - 1.085068e+20*R_pow(x, 34.0) + 1.705107e+20*R_pow(x, 36.0) - 2.231434e+20*R_pow(x, 38.0) + 2.420248e+20*R_pow(x, 40.0) - 2.158827e+20*R_pow(x, 42.0) + 1.565492e+20*R_pow(x, 44.0) - 9.075316e+19*R_pow(x, 46.0) + 4.103201e+19*R_pow(x, 48.0) - 1.393414e+19*R_pow(x, 50.0) + 3.341671e+18*R_pow(x, 52.0) - 5.044032e+17*R_pow(x, 54.0) + 3.602880e+16*R_pow(x, 56.0);
    }
    break;
  case 57:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 5.700000e+01*x - 3.085600e+04*R_pow(x, 3.0) + 4.998672e+06*R_pow(x, 5.0) - 3.837076e+08*R_pow(x, 7.0) + 1.705367e+10*R_pow(x, 9.0) - 4.911457e+11*R_pow(x, 11.0) + 9.848101e+12*R_pow(x, 13.0) - 1.444388e+14*R_pow(x, 15.0) + 1.605820e+15*R_pow(x, 17.0) - 1.389832e+16*R_pow(x, 19.0) + 9.556752e+16*R_pow(x, 21.0) - 5.303431e+17*R_pow(x, 23.0) + 2.404222e+18*R_pow(x, 25.0) - 8.986721e+18*R_pow(x, 27.0) + 2.788982e+19*R_pow(x, 29.0) - 7.221365e+19*R_pow(x, 31.0) + 1.564629e+20*R_pow(x, 33.0) - 2.839999e+20*R_pow(x, 35.0) + 4.315434e+20*R_pow(x, 37.0) - 5.474370e+20*R_pow(x, 39.0) + 5.768116e+20*R_pow(x, 41.0) - 5.007977e+20*R_pow(x, 43.0) + 3.540994e+20*R_pow(x, 45.0) - 2.004707e+20*R_pow(x, 47.0) + 8.864351e+19*R_pow(x, 49.0) - 2.947831e+19*R_pow(x, 51.0) + 6.931040e+18*R_pow(x, 53.0) - 1.026821e+18*R_pow(x, 55.0) + 7.205759e+16*R_pow(x, 57.0);
    }
    break;
  case 58:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 1.682000e+03*R_pow(x, 2.0) - 4.709600e+05*R_pow(x, 4.0) + 5.255914e+07*R_pow(x, 6.0) - 3.123514e+09*R_pow(x, 8.0) + 1.145289e+11*R_pow(x, 10.0) - 2.831986e+12*R_pow(x, 12.0) + 5.010437e+13*R_pow(x, 14.0) - 6.613777e+14*R_pow(x, 16.0) + 6.717523e+15*R_pow(x, 18.0) - 5.374018e+16*R_pow(x, 20.0) + 3.447747e+17*R_pow(x, 22.0) - 1.798824e+18*R_pow(x, 24.0) + 7.715573e+18*R_pow(x, 26.0) - 2.743315e+19*R_pow(x, 28.0) + 8.135348e+19*R_pow(x, 30.0) - 2.020715e+20*R_pow(x, 32.0) + 4.214326e+20*R_pow(x, 34.0) - 7.385105e+20*R_pow(x, 36.0) + 1.086230e+21*R_pow(x, 38.0) - 1.336899e+21*R_pow(x, 40.0) + 1.369506e+21*R_pow(x, 42.0) - 1.158145e+21*R_pow(x, 44.0) + 7.989519e+20*R_pow(x, 46.0) - 4.419734e+20*R_pow(x, 48.0) + 1.912212e+20*R_pow(x, 50.0) - 6.229829e+19*R_pow(x, 52.0) + 1.436648e+19*R_pow(x, 54.0) - 2.089670e+18*R_pow(x, 56.0) + 1.441152e+17*R_pow(x, 58.0);
    }
    break;
  case 59:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -5.900000e+01*x + 3.422000e+04*R_pow(x, 3.0) - 5.940592e+06*R_pow(x, 5.0) + 4.888259e+08*R_pow(x, 7.0) - 2.330070e+10*R_pow(x, 9.0) + 7.202034e+11*R_pow(x, 11.0) - 1.551207e+13*R_pow(x, 13.0) + 2.446476e+14*R_pow(x, 15.0) - 2.928575e+15*R_pow(x, 17.0) + 2.733337e+16*R_pow(x, 19.0) - 2.030479e+17*R_pow(x, 21.0) + 1.219892e+18*R_pow(x, 23.0) - 6.001871e+18*R_pow(x, 25.0) + 2.441787e+19*R_pow(x, 27.0) - 8.275612e+19*R_pow(x, 29.0) + 2.349206e+20*R_pow(x, 31.0) - 5.606060e+20*R_pow(x, 33.0) + 1.126865e+21*R_pow(x, 35.0) - 1.908564e+21*R_pow(x, 37.0) + 2.719897e+21*R_pow(x, 39.0) - 3.250609e+21*R_pow(x, 41.0) + 3.239810e+21*R_pow(x, 43.0) - 2.670389e+21*R_pow(x, 45.0) + 1.798375e+21*R_pow(x, 47.0) - 9.725903e+20*R_pow(x, 49.0) + 4.119206e+20*R_pow(x, 51.0) - 1.315276e+20*R_pow(x, 53.0) + 2.975979e+19*R_pow(x, 55.0) - 4.251398e+18*R_pow(x, 57.0) + 2.882304e+17*R_pow(x, 59.0);
    }
    break;
  case 60:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 1.800000e+03*R_pow(x, 2.0) + 5.394000e+05*R_pow(x, 4.0) - 6.444032e+07*R_pow(x, 6.0) + 4.101166e+09*R_pow(x, 8.0) - 1.611303e+11*R_pow(x, 10.0) + 4.272393e+12*R_pow(x, 12.0) - 8.112852e+13*R_pow(x, 14.0) + 1.150673e+15*R_pow(x, 16.0) - 1.257467e+16*R_pow(x, 18.0) + 1.084069e+17*R_pow(x, 20.0) - 7.508705e+17*R_pow(x, 22.0) + 4.238609e+18*R_pow(x, 24.0) - 1.971931e+19*R_pow(x, 26.0) + 7.626888e+19*R_pow(x, 28.0) - 2.468657e+20*R_pow(x, 30.0) + 6.719127e+20*R_pow(x, 32.0) - 1.542645e+21*R_pow(x, 34.0) + 2.992241e+21*R_pow(x, 36.0) - 4.903359e+21*R_pow(x, 38.0) + 6.776694e+21*R_pow(x, 40.0) - 7.870724e+21*R_pow(x, 42.0) + 7.637764e+21*R_pow(x, 44.0) - 6.139729e+21*R_pow(x, 46.0) + 4.038723e+21*R_pow(x, 48.0) - 2.136402e+21*R_pow(x, 50.0) + 8.861395e+20*R_pow(x, 52.0) - 2.774217e+20*R_pow(x, 54.0) + 6.160924e+19*R_pow(x, 56.0) - 8.646911e+18*R_pow(x, 58.0) + 5.764608e+17*R_pow(x, 60.0);
    }
    break;
  case 61:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 6.100000e+01*x - 3.782000e+04*R_pow(x, 3.0) + 7.019392e+06*R_pow(x, 5.0) - 6.177065e+08*R_pow(x, 7.0) + 3.150303e+10*R_pow(x, 9.0) - 1.042464e+12*R_pow(x, 11.0) + 2.405686e+13*R_pow(x, 13.0) - 4.069046e+14*R_pow(x, 15.0) + 5.229921e+15*R_pow(x, 17.0) - 5.248272e+16*R_pow(x, 19.0) + 4.198617e+17*R_pow(x, 21.0) - 2.721633e+18*R_pow(x, 23.0) + 1.447909e+19*R_pow(x, 25.0) - 6.385650e+19*R_pow(x, 27.0) + 2.352939e+20*R_pow(x, 29.0) - 7.286520e+20*R_pow(x, 31.0) + 1.904431e+21*R_pow(x, 33.0) - 4.212154e+21*R_pow(x, 35.0) + 7.893046e+21*R_pow(x, 37.0) - 1.252662e+22*R_pow(x, 39.0) + 1.680400e+22*R_pow(x, 41.0) - 1.898126e+22*R_pow(x, 43.0) + 1.794592e+22*R_pow(x, 45.0) - 1.407783e+22*R_pow(x, 47.0) + 9.050036e+21*R_pow(x, 49.0) - 4.684724e+21*R_pow(x, 51.0) + 1.903807e+21*R_pow(x, 53.0) - 5.846033e+20*R_pow(x, 55.0) + 1.274699e+20*R_pow(x, 57.0) - 1.758205e+19*R_pow(x, 59.0) + 1.152922e+18*R_pow(x, 61.0);
    }
    break;
  case 62:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 1.922000e+03*R_pow(x, 2.0) - 6.150400e+05*R_pow(x, 4.0) + 7.847910e+07*R_pow(x, 6.0) - 5.336579e+09*R_pow(x, 8.0) + 2.241363e+11*R_pow(x, 10.0) - 6.357321e+12*R_pow(x, 12.0) + 1.292422e+14*R_pow(x, 14.0) - 1.964482e+15*R_pow(x, 16.0) + 2.303452e+16*R_pow(x, 18.0) - 2.133724e+17*R_pow(x, 20.0) + 1.590594e+18*R_pow(x, 22.0) - 9.681876e+18*R_pow(x, 24.0) + 4.867749e+19*R_pow(x, 26.0) - 2.039819e+20*R_pow(x, 28.0) + 7.174535e+20*R_pow(x, 30.0) - 2.129217e+21*R_pow(x, 32.0) + 5.351508e+21*R_pow(x, 34.0) - 1.141655e+22*R_pow(x, 36.0) + 2.068945e+22*R_pow(x, 38.0) - 3.182992e+22*R_pow(x, 40.0) + 4.147872e+22*R_pow(x, 42.0) - 4.560028e+22*R_pow(x, 44.0) + 4.203156e+22*R_pow(x, 46.0) - 3.219439e+22*R_pow(x, 48.0) + 2.023647e+22*R_pow(x, 50.0) - 1.025559e+22*R_pow(x, 52.0) + 4.085035e+21*R_pow(x, 54.0) - 1.230816e+21*R_pow(x, 56.0) + 2.635867e+20*R_pow(x, 58.0) - 3.574057e+19*R_pow(x, 60.0) + 2.305843e+18*R_pow(x, 62.0);
    }
    break;
  case 63:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -6.300000e+01*x + 4.166400e+04*R_pow(x, 3.0) - 8.249472e+06*R_pow(x, 5.0) + 7.746647e+08*R_pow(x, 7.0) - 4.217619e+10*R_pow(x, 9.0) + 1.490737e+12*R_pow(x, 11.0) - 3.677150e+13*R_pow(x, 13.0) + 6.653891e+14*R_pow(x, 15.0) - 9.158885e+15*R_pow(x, 17.0) + 9.855175e+16*R_pow(x, 19.0) - 8.466064e+17*R_pow(x, 21.0) + 5.902821e+18*R_pow(x, 23.0) - 3.384284e+19*R_pow(x, 25.0) + 1.612115e+20*R_pow(x, 27.0) - 6.432576e+20*R_pow(x, 29.0) + 2.163559e+21*R_pow(x, 31.0) - 6.162865e+21*R_pow(x, 33.0) + 1.491517e+22*R_pow(x, 35.0) - 3.072614e+22*R_pow(x, 37.0) + 5.390552e+22*R_pow(x, 39.0) - 8.046384e+22*R_pow(x, 41.0) + 1.019387e+23*R_pow(x, 43.0) - 1.091465e+23*R_pow(x, 45.0) + 9.814096e+22*R_pow(x, 47.0) - 7.343881e+22*R_pow(x, 49.0) + 4.515767e+22*R_pow(x, 51.0) - 2.241498e+22*R_pow(x, 53.0) + 8.754673e+21*R_pow(x, 55.0) - 2.589101e+21*R_pow(x, 57.0) + 5.447554e+20*R_pow(x, 59.0) - 7.263405e+19*R_pow(x, 61.0) + 4.611686e+18*R_pow(x, 63.0);
    }
    break;
  case 64:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 2.048000e+03*R_pow(x, 2.0) + 6.983680e+05*R_pow(x, 4.0) - 9.497805e+07*R_pow(x, 6.0) + 6.885908e+09*R_pow(x, 8.0) - 3.084887e+11*R_pow(x, 10.0) + 9.338794e+12*R_pow(x, 12.0) - 2.027852e+14*R_pow(x, 14.0) + 3.295260e+15*R_pow(x, 16.0) - 4.135229e+16*R_pow(x, 18.0) + 4.104758e+17*R_pow(x, 20.0) - 3.283807e+18*R_pow(x, 22.0) + 2.148752e+19*R_pow(x, 24.0) - 1.163632e+20*R_pow(x, 26.0) + 5.264048e+20*R_pow(x, 28.0) - 2.003969e+21*R_pow(x, 30.0) + 6.456335e+21*R_pow(x, 32.0) - 1.767724e+22*R_pow(x, 34.0) + 4.124689e+22*R_pow(x, 36.0) - 8.214174e+22*R_pow(x, 38.0) + 1.396410e+23*R_pow(x, 40.0) - 2.024064e+23*R_pow(x, 42.0) + 2.494777e+23*R_pow(x, 44.0) - 2.603245e+23*R_pow(x, 46.0) + 2.284763e+23*R_pow(x, 48.0) - 1.671141e+23*R_pow(x, 50.0) + 1.005709e+23*R_pow(x, 52.0) - 4.891500e+22*R_pow(x, 54.0) + 1.874016e+22*R_pow(x, 56.0) - 5.441790e+21*R_pow(x, 58.0) + 1.125251e+21*R_pow(x, 60.0) - 1.475740e+20*R_pow(x, 62.0) + 9.223372e+18*R_pow(x, 64.0);
    }
    break;
  case 65:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 6.500000e+01*x - 4.576000e+04*R_pow(x, 3.0) + 9.646208e+06*R_pow(x, 5.0) - 9.646208e+08*R_pow(x, 7.0) + 5.594801e+10*R_pow(x, 9.0) - 2.107714e+12*R_pow(x, 11.0) + 5.544909e+13*R_pow(x, 13.0) - 1.070960e+15*R_pow(x, 15.0) + 1.574941e+16*R_pow(x, 17.0) - 1.812563e+17*R_pow(x, 19.0) + 1.667558e+18*R_pow(x, 21.0) - 1.247043e+19*R_pow(x, 23.0) + 7.681788e+19*R_pow(x, 25.0) - 3.939378e+20*R_pow(x, 27.0) + 1.696067e+21*R_pow(x, 29.0) - 6.171497e+21*R_pow(x, 31.0) + 1.907553e+22*R_pow(x, 33.0) - 5.026964e+22*R_pow(x, 35.0) + 1.132199e+23*R_pow(x, 37.0) - 2.181890e+23*R_pow(x, 39.0) + 3.597458e+23*R_pow(x, 41.0) - 5.067515e+23*R_pow(x, 43.0) + 6.081018e+23*R_pow(x, 45.0) - 6.187900e+23*R_pow(x, 47.0) + 5.303914e+23*R_pow(x, 49.0) - 3.793859e+23*R_pow(x, 51.0) + 2.235568e+23*R_pow(x, 53.0) - 1.065847e+23*R_pow(x, 55.0) + 4.006943e+22*R_pow(x, 57.0) - 1.142833e+22*R_pow(x, 59.0) + 2.323137e+21*R_pow(x, 61.0) - 2.997596e+20*R_pow(x, 63.0) + 1.844674e+19*R_pow(x, 65.0);
    }
    break;
  case 66:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 2.178000e+03*R_pow(x, 2.0) - 7.898880e+05*R_pow(x, 4.0) + 1.142705e+08*R_pow(x, 6.0) - 8.815150e+09*R_pow(x, 8.0) + 4.203847e+11*R_pow(x, 10.0) - 1.355422e+13*R_pow(x, 12.0) + 3.136834e+14*R_pow(x, 14.0) - 5.437179e+15*R_pow(x, 16.0) + 7.285110e+16*R_pow(x, 18.0) - 7.729885e+17*R_pow(x, 20.0) + 6.618923e+18*R_pow(x, 22.0) - 4.642839e+19*R_pow(x, 24.0) + 2.699989e+20*R_pow(x, 26.0) - 1.314281e+21*R_pow(x, 28.0) + 5.396103e+21*R_pow(x, 30.0) - 1.879933e+22*R_pow(x, 32.0) + 5.582831e+22*R_pow(x, 34.0) - 1.417862e+23*R_pow(x, 36.0) + 3.085816e+23*R_pow(x, 38.0) - 5.760190e+23*R_pow(x, 40.0) + 9.218979e+23*R_pow(x, 42.0) - 1.262981e+24*R_pow(x, 44.0) + 1.476528e+24*R_pow(x, 46.0) - 1.466056e+24*R_pow(x, 48.0) + 1.227897e+24*R_pow(x, 50.0) - 8.593427e+23*R_pow(x, 52.0) + 4.960287e+23*R_pow(x, 54.0) - 2.319095e+23*R_pow(x, 56.0) + 8.558064e+22*R_pow(x, 58.0) - 2.398192e+22*R_pow(x, 60.0) + 4.793848e+21*R_pow(x, 62.0) - 6.087426e+20*R_pow(x, 64.0) + 3.689349e+19*R_pow(x, 66.0);
    }
    break;
  case 67:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -6.700000e+01*x + 5.011600e+04*R_pow(x, 3.0) - 1.122598e+07*R_pow(x, 5.0) + 1.193162e+09*R_pow(x, 7.0) - 7.357831e+10*R_pow(x, 9.0) + 2.948483e+12*R_pow(x, 11.0) - 8.255754e+13*R_pow(x, 13.0) + 1.698326e+15*R_pow(x, 15.0) - 2.662376e+16*R_pow(x, 17.0) + 3.269585e+17*R_pow(x, 19.0) - 3.213535e+18*R_pow(x, 21.0) + 2.570828e+19*R_pow(x, 23.0) - 1.696747e+20*R_pow(x, 25.0) + 9.339357e+20*R_pow(x, 27.0) - 4.324628e+21*R_pow(x, 29.0) + 1.696370e+22*R_pow(x, 31.0) - 5.667419e+22*R_pow(x, 33.0) + 1.619263e+23*R_pow(x, 35.0) - 3.967923e+23*R_pow(x, 37.0) + 8.353522e+23*R_pow(x, 39.0) - 1.511784e+24*R_pow(x, 41.0) + 2.350547e+24*R_pow(x, 43.0) - 3.134063e+24*R_pow(x, 45.0) + 3.571846e+24*R_pow(x, 47.0) - 3.462504e+24*R_pow(x, 49.0) + 2.835180e+24*R_pow(x, 51.0) - 1.942242e+24*R_pow(x, 53.0) + 1.098642e+24*R_pow(x, 55.0) - 5.038885e+23*R_pow(x, 57.0) + 1.825896e+23*R_pow(x, 59.0) - 5.028698e+22*R_pow(x, 61.0) + 9.887455e+21*R_pow(x, 63.0) - 1.235932e+21*R_pow(x, 65.0) + 7.378698e+19*R_pow(x, 67.0);
    }
    break;
  case 68:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 2.312000e+03*R_pow(x, 2.0) + 8.901200e+05*R_pow(x, 4.0) - 1.367224e+08*R_pow(x, 6.0) + 1.120147e+10*R_pow(x, 8.0) - 5.675413e+11*R_pow(x, 10.0) + 1.945119e+13*R_pow(x, 12.0) - 4.787985e+14*R_pow(x, 14.0) + 8.833832e+15*R_pow(x, 16.0) - 1.260986e+17*R_pow(x, 18.0) + 1.426906e+18*R_pow(x, 20.0) - 1.304599e+19*R_pow(x, 22.0) + 9.784495e+19*R_pow(x, 24.0) - 6.093482e+20*R_pow(x, 26.0) + 3.182152e+21*R_pow(x, 28.0) - 1.404536e+22*R_pow(x, 30.0) + 5.272673e+22*R_pow(x, 32.0) - 1.691767e+23*R_pow(x, 34.0) + 4.656387e+23*R_pow(x, 36.0) - 1.102166e+24*R_pow(x, 38.0) + 2.246723e+24*R_pow(x, 40.0) - 3.945465e+24*R_pow(x, 42.0) + 5.964075e+24*R_pow(x, 44.0) - 7.744654e+24*R_pow(x, 46.0) + 8.609749e+24*R_pow(x, 48.0) - 8.152905e+24*R_pow(x, 50.0) + 6.529702e+24*R_pow(x, 52.0) - 4.380513e+24*R_pow(x, 54.0) + 2.429194e+24*R_pow(x, 56.0) - 1.093358e+24*R_pow(x, 58.0) + 3.891612e+23*R_pow(x, 60.0) - 1.053678e+23*R_pow(x, 62.0) + 2.038365e+22*R_pow(x, 64.0) - 2.508757e+21*R_pow(x, 66.0) + 1.475740e+20*R_pow(x, 68.0);
    }
    break;
  case 69:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 6.900000e+01*x - 5.474000e+04*R_pow(x, 3.0) + 1.300622e+07*R_pow(x, 5.0) - 1.466607e+09*R_pow(x, 7.0) + 9.598125e+10*R_pow(x, 9.0) - 4.083566e+12*R_pow(x, 11.0) + 1.214599e+14*R_pow(x, 13.0) - 2.655923e+15*R_pow(x, 15.0) + 4.429143e+16*R_pow(x, 17.0) - 5.791558e+17*R_pow(x, 19.0) + 6.067346e+18*R_pow(x, 21.0) - 5.180027e+19*R_pow(x, 23.0) + 3.653646e+20*R_pow(x, 25.0) - 2.152632e+21*R_pow(x, 27.0) + 1.068893e+22*R_pow(x, 29.0) - 4.505442e+22*R_pow(x, 31.0) + 1.621277e+23*R_pow(x, 33.0) - 5.002796e+23*R_pow(x, 35.0) + 1.328070e+24*R_pow(x, 37.0) - 3.039684e+24*R_pow(x, 39.0) + 6.005230e+24*R_pow(x, 41.0) - 1.024148e+25*R_pow(x, 43.0) + 1.506221e+25*R_pow(x, 45.0) - 1.906116e+25*R_pow(x, 47.0) + 2.068200e+25*R_pow(x, 49.0) - 1.914099e+25*R_pow(x, 51.0) + 1.500165e+25*R_pow(x, 53.0) - 9.859668e+24*R_pow(x, 55.0) + 5.362276e+24*R_pow(x, 57.0) - 2.369305e+24*R_pow(x, 59.0) + 8.286093e+23*R_pow(x, 61.0) - 2.206231e+23*R_pow(x, 63.0) + 4.200324e+22*R_pow(x, 65.0) - 5.091301e+21*R_pow(x, 67.0) + 2.951479e+20*R_pow(x, 69.0);
    }
    break;
  case 70:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 2.450000e+03*R_pow(x, 2.0) - 9.996000e+05*R_pow(x, 4.0) + 1.627349e+08*R_pow(x, 6.0) - 1.413469e+10*R_pow(x, 8.0) + 7.595038e+11*R_pow(x, 10.0) - 2.761832e+13*R_pow(x, 12.0) + 7.217183e+14*R_pow(x, 14.0) - 1.414568e+16*R_pow(x, 16.0) + 2.146815e+17*R_pow(x, 18.0) - 2.585217e+18*R_pow(x, 20.0) + 2.518069e+19*R_pow(x, 22.0) - 2.014455e+20*R_pow(x, 24.0) + 1.340077e+21*R_pow(x, 26.0) - 7.487416e+21*R_pow(x, 28.0) + 3.542322e+22*R_pow(x, 30.0) - 1.428356e+23*R_pow(x, 32.0) + 4.934320e+23*R_pow(x, 34.0) - 1.466198e+24*R_pow(x, 36.0) + 3.758305e+24*R_pow(x, 38.0) - 8.326092e+24*R_pow(x, 40.0) + 1.595593e+25*R_pow(x, 42.0) - 2.644703e+25*R_pow(x, 44.0) + 3.786908e+25*R_pow(x, 46.0) - 4.673206e+25*R_pow(x, 48.0) + 4.951691e+25*R_pow(x, 50.0) - 4.481168e+25*R_pow(x, 52.0) + 3.438381e+25*R_pow(x, 54.0) - 2.214853e+25*R_pow(x, 56.0) + 1.181791e+25*R_pow(x, 58.0) - 5.127771e+24*R_pow(x, 60.0) + 1.762586e+24*R_pow(x, 62.0) - 4.616298e+23*R_pow(x, 64.0) + 8.651523e+22*R_pow(x, 66.0) - 1.033018e+22*R_pow(x, 68.0) + 5.902958e+20*R_pow(x, 70.0);
    }
    break;
  case 71:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -7.100000e+01*x + 5.964000e+04*R_pow(x, 3.0) - 1.500542e+07*R_pow(x, 5.0) + 1.792076e+09*R_pow(x, 7.0) - 1.242506e+11*R_pow(x, 9.0) + 5.602574e+12*R_pow(x, 11.0) - 1.766966e+14*R_pow(x, 13.0) + 4.099360e+15*R_pow(x, 15.0) - 7.258279e+16*R_pow(x, 17.0) + 1.008519e+18*R_pow(x, 19.0) - 1.123778e+19*R_pow(x, 21.0) + 1.021616e+20*R_pow(x, 23.0) - 7.682555e+20*R_pow(x, 25.0) + 4.832787e+21*R_pow(x, 27.0) - 2.566376e+22*R_pow(x, 29.0) + 1.159009e+23*R_pow(x, 31.0) - 4.477988e+23*R_pow(x, 33.0) + 1.487144e+24*R_pow(x, 35.0) - 4.260466e+24*R_pow(x, 37.0) + 1.055630e+25*R_pow(x, 39.0) - 2.265741e+25*R_pow(x, 41.0) + 4.215333e+25*R_pow(x, 43.0) - 6.795628e+25*R_pow(x, 45.0) + 9.479932e+25*R_pow(x, 47.0) - 1.141461e+26*R_pow(x, 49.0) + 1.181748e+26*R_pow(x, 51.0) - 1.046250e+26*R_pow(x, 53.0) + 7.862728e+25*R_pow(x, 55.0) - 4.965933e+25*R_pow(x, 57.0) + 2.600512e+25*R_pow(x, 59.0) - 1.108415e+25*R_pow(x, 61.0) + 3.745796e+24*R_pow(x, 63.0) - 9.652628e+23*R_pow(x, 65.0) + 1.781218e+23*R_pow(x, 67.0) - 2.095550e+22*R_pow(x, 69.0) + 1.180592e+21*R_pow(x, 71.0);
    }
    break;
  case 72:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 2.592000e+03*R_pow(x, 2.0) + 1.118880e+06*R_pow(x, 4.0) - 1.927457e+08*R_pow(x, 6.0) + 1.771884e+10*R_pow(x, 8.0) - 1.008005e+12*R_pow(x, 10.0) + 3.882347e+13*R_pow(x, 12.0) - 1.075111e+15*R_pow(x, 14.0) + 2.234440e+16*R_pow(x, 16.0) - 3.598471e+17*R_pow(x, 18.0) + 4.602255e+18*R_pow(x, 20.0) - 4.765625e+19*R_pow(x, 22.0) + 4.057688e+20*R_pow(x, 24.0) - 2.876588e+21*R_pow(x, 26.0) + 1.715299e+22*R_pow(x, 28.0) - 8.675075e+22*R_pow(x, 30.0) + 3.746373e+23*R_pow(x, 32.0) - 1.389030e+24*R_pow(x, 34.0) + 4.440485e+24*R_pow(x, 36.0) - 1.227924e+25*R_pow(x, 38.0) + 2.943868e+25*R_pow(x, 40.0) - 6.127075e+25*R_pow(x, 42.0) + 1.107537e+26*R_pow(x, 44.0) - 1.737816e+26*R_pow(x, 46.0) + 2.363307e+26*R_pow(x, 48.0) - 2.778091e+26*R_pow(x, 50.0) + 2.811613e+26*R_pow(x, 52.0) - 2.436338e+26*R_pow(x, 54.0) + 1.794031e+26*R_pow(x, 56.0) - 1.111366e+26*R_pow(x, 58.0) + 5.713802e+25*R_pow(x, 60.0) - 2.393089e+25*R_pow(x, 62.0) + 7.953221e+24*R_pow(x, 64.0) - 2.017041e+24*R_pow(x, 66.0) + 3.665737e+23*R_pow(x, 68.0) - 4.250130e+22*R_pow(x, 70.0) + 2.361183e+21*R_pow(x, 72.0);
    }
    break;
  case 73:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 7.300000e+01*x - 6.482400e+04*R_pow(x, 3.0) + 1.724318e+07*R_pow(x, 5.0) - 2.177568e+09*R_pow(x, 7.0) + 1.596883e+11*R_pow(x, 9.0) - 7.618584e+12*R_pow(x, 11.0) + 2.543435e+14*R_pow(x, 13.0) - 6.249583e+15*R_pow(x, 15.0) + 1.172716e+17*R_pow(x, 17.0) - 1.728213e+18*R_pow(x, 19.0) + 2.044229e+19*R_pow(x, 21.0) - 1.974741e+20*R_pow(x, 23.0) + 1.579793e+21*R_pow(x, 25.0) - 1.058596e+22*R_pow(x, 27.0) + 5.996974e+22*R_pow(x, 29.0) - 2.894024e+23*R_pow(x, 31.0) + 1.197073e+24*R_pow(x, 33.0) - 4.265203e+24*R_pow(x, 35.0) + 1.314144e+25*R_pow(x, 37.0) - 3.511477e+25*R_pow(x, 39.0) + 8.153478e+25*R_pow(x, 41.0) - 1.646948e+26*R_pow(x, 43.0) + 2.894637e+26*R_pow(x, 45.0) - 4.423626e+26*R_pow(x, 47.0) + 5.868075e+26*R_pow(x, 49.0) - 6.737931e+26*R_pow(x, 51.0) + 6.669476e+26*R_pow(x, 53.0) - 5.658949e+26*R_pow(x, 55.0) + 4.084655e+26*R_pow(x, 57.0) - 2.482783e+26*R_pow(x, 59.0) + 1.253602e+26*R_pow(x, 61.0) - 5.160757e+25*R_pow(x, 63.0) + 1.687171e+25*R_pow(x, 65.0) - 4.212203e+24*R_pow(x, 67.0) + 7.541029e+23*R_pow(x, 69.0) - 8.618319e+22*R_pow(x, 71.0) + 4.722366e+21*R_pow(x, 73.0);
    }
    break;
  case 74:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 2.738000e+03*R_pow(x, 2.0) - 1.248528e+06*R_pow(x, 4.0) + 2.272321e+08*R_pow(x, 6.0) - 2.207398e+10*R_pow(x, 8.0) + 1.327382e+12*R_pow(x, 10.0) - 5.406064e+13*R_pow(x, 12.0) + 1.583798e+15*R_pow(x, 14.0) - 3.484357e+16*R_pow(x, 16.0) + 5.943902e+17*R_pow(x, 18.0) - 8.058680e+18*R_pow(x, 20.0) + 8.854082e+19*R_pow(x, 22.0) - 8.007170e+20*R_pow(x, 24.0) + 6.036174e+21*R_pow(x, 26.0) - 3.832492e+22*R_pow(x, 28.0) + 2.066902e+23*R_pow(x, 30.0) - 9.534421e+23*R_pow(x, 32.0) + 3.783177e+24*R_pow(x, 34.0) - 1.297089e+25*R_pow(x, 36.0) + 3.856211e+25*R_pow(x, 38.0) - 9.966822e+25*R_pow(x, 40.0) + 2.243403e+26*R_pow(x, 42.0) - 4.401434e+26*R_pow(x, 44.0) + 7.527089e+26*R_pow(x, 46.0) - 1.121056e+27*R_pow(x, 48.0) + 1.451424e+27*R_pow(x, 50.0) - 1.628748e+27*R_pow(x, 52.0) + 1.577529e+27*R_pow(x, 54.0) - 1.311193e+27*R_pow(x, 56.0) + 9.280676e+26*R_pow(x, 58.0) - 5.536946e+26*R_pow(x, 60.0) + 2.746512e+26*R_pow(x, 62.0) - 1.111684e+26*R_pow(x, 64.0) + 3.576045e+25*R_pow(x, 66.0) - 8.790980e+24*R_pow(x, 68.0) + 1.550707e+24*R_pow(x, 70.0) - 1.747276e+23*R_pow(x, 72.0) + 9.444733e+21*R_pow(x, 74.0);
    }
    break;
  case 75:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -7.500000e+01*x + 7.030000e+04*R_pow(x, 3.0) - 1.974024e+07*R_pow(x, 5.0) + 2.632032e+09*R_pow(x, 7.0) - 2.038363e+11*R_pow(x, 9.0) + 1.027335e+13*R_pow(x, 11.0) - 3.624648e+14*R_pow(x, 13.0) + 9.417180e+15*R_pow(x, 15.0) - 1.869587e+17*R_pow(x, 17.0) + 2.916993e+18*R_pow(x, 19.0) - 3.655965e+19*R_pow(x, 21.0) + 3.745558e+20*R_pow(x, 23.0) - 3.181227e+21*R_pow(x, 25.0) + 2.265831e+22*R_pow(x, 27.0) - 1.366196e+23*R_pow(x, 29.0) + 7.027829e+23*R_pow(x, 31.0) - 3.103958e+24*R_pow(x, 33.0) + 1.183156e+25*R_pow(x, 35.0) - 3.908322e+25*R_pow(x, 37.0) + 1.122390e+26*R_pow(x, 39.0) - 2.808712e+26*R_pow(x, 41.0) + 6.133755e+26*R_pow(x, 43.0) - 1.169750e+27*R_pow(x, 45.0) + 1.947780e+27*R_pow(x, 47.0) - 2.828919e+27*R_pow(x, 49.0) + 3.576641e+27*R_pow(x, 51.0) - 3.924443e+27*R_pow(x, 53.0) + 3.720953e+27*R_pow(x, 55.0) - 3.030851e+27*R_pow(x, 57.0) + 2.104413e+27*R_pow(x, 59.0) - 1.232749e+27*R_pow(x, 61.0) + 6.009101e+26*R_pow(x, 63.0) - 2.392084e+26*R_pow(x, 65.0) + 7.573311e+25*R_pow(x, 67.0) - 1.833606e+25*R_pow(x, 69.0) + 3.187597e+24*R_pow(x, 71.0) - 3.541775e+23*R_pow(x, 73.0) + 1.888947e+22*R_pow(x, 75.0);
    }
    break;
  case 76:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 2.888000e+03*R_pow(x, 2.0) + 1.389128e+06*R_pow(x, 4.0) - 2.667126e+08*R_pow(x, 6.0) + 2.733804e+10*R_pow(x, 8.0) - 1.735054e+12*R_pow(x, 10.0) + 7.460733e+13*R_pow(x, 12.0) - 2.308728e+15*R_pow(x, 14.0) + 5.367793e+16*R_pow(x, 16.0) - 9.683077e+17*R_pow(x, 18.0) + 1.389267e+19*R_pow(x, 20.0) - 1.616601e+20*R_pow(x, 22.0) + 1.549829e+21*R_pow(x, 24.0) - 1.239863e+22*R_pow(x, 26.0) + 8.364154e+22*R_pow(x, 28.0) - 4.799294e+23*R_pow(x, 30.0) + 2.359008e+24*R_pow(x, 32.0) - 9.991092e+24*R_pow(x, 34.0) + 3.663400e+25*R_pow(x, 36.0) - 1.167285e+26*R_pow(x, 38.0) + 3.241462e+26*R_pow(x, 40.0) - 7.860828e+26*R_pow(x, 42.0) + 1.666894e+27*R_pow(x, 44.0) - 3.092210e+27*R_pow(x, 46.0) + 5.016617e+27*R_pow(x, 48.0) - 7.109263e+27*R_pow(x, 50.0) + 8.782030e+27*R_pow(x, 52.0) - 9.426414e+27*R_pow(x, 54.0) + 8.753099e+27*R_pow(x, 56.0) - 6.989770e+27*R_pow(x, 58.0) + 4.762522e+27*R_pow(x, 60.0) - 2.740150e+27*R_pow(x, 62.0) + 1.312988e+27*R_pow(x, 64.0) - 5.141773e+26*R_pow(x, 66.0) + 1.602572e+26*R_pow(x, 68.0) - 3.822283e+25*R_pow(x, 70.0) + 6.549922e+24*R_pow(x, 72.0) - 7.177997e+23*R_pow(x, 74.0) + 3.777893e+22*R_pow(x, 76.0);
    }
    break;
  case 77:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 7.700000e+01*x - 7.607600e+04*R_pow(x, 3.0) + 2.251850e+07*R_pow(x, 5.0) - 3.165457e+09*R_pow(x, 7.0) + 2.585123e+11*R_pow(x, 9.0) - 1.374346e+13*R_pow(x, 11.0) + 5.116794e+14*R_pow(x, 13.0) - 1.403464e+16*R_pow(x, 15.0) + 2.943146e+17*R_pow(x, 17.0) - 4.853609e+18*R_pow(x, 19.0) + 6.434498e+19*R_pow(x, 21.0) - 6.978760e+20*R_pow(x, 23.0) + 6.280884e+21*R_pow(x, 25.0) - 4.745557e+22*R_pow(x, 27.0) + 3.039027e+23*R_pow(x, 29.0) - 1.662642e+24*R_pow(x, 31.0) + 7.821973e+24*R_pow(x, 33.0) - 3.181374e+25*R_pow(x, 35.0) + 1.123512e+26*R_pow(x, 37.0) - 3.456961e+26*R_pow(x, 39.0) + 9.291636e+26*R_pow(x, 41.0) - 2.185541e+27*R_pow(x, 43.0) + 4.503539e+27*R_pow(x, 45.0) - 8.132200e+27*R_pow(x, 47.0) + 1.286215e+28*R_pow(x, 49.0) - 1.779517e+28*R_pow(x, 51.0) + 2.148850e+28*R_pow(x, 53.0) - 2.257378e+28*R_pow(x, 55.0) + 2.053705e+28*R_pow(x, 57.0) - 1.608395e+28*R_pow(x, 59.0) + 1.075779e+28*R_pow(x, 61.0) - 6.081210e+27*R_pow(x, 63.0) + 2.865185e+27*R_pow(x, 65.0) - 1.104088e+27*R_pow(x, 67.0) + 3.388505e+26*R_pow(x, 69.0) - 7.963327e+25*R_pow(x, 71.0) + 1.345402e+25*R_pow(x, 73.0) - 1.454489e+24*R_pow(x, 75.0) + 7.555786e+22*R_pow(x, 77.0);
    }
    break;
  case 78:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 3.042000e+03*R_pow(x, 2.0) - 1.541280e+06*R_pow(x, 4.0) + 3.117496e+08*R_pow(x, 6.0) - 3.366895e+10*R_pow(x, 8.0) + 2.252079e+12*R_pow(x, 10.0) - 1.020942e+14*R_pow(x, 12.0) + 3.332087e+15*R_pow(x, 14.0) - 8.174720e+16*R_pow(x, 16.0) + 1.556937e+18*R_pow(x, 18.0) - 2.359988e+19*R_pow(x, 20.0) + 2.903501e+20*R_pow(x, 22.0) - 2.945581e+21*R_pow(x, 24.0) + 2.496040e+22*R_pow(x, 26.0) - 1.785527e+23*R_pow(x, 28.0) + 1.087735e+24*R_pow(x, 30.0) - 5.684291e+24*R_pow(x, 32.0) + 2.563504e+25*R_pow(x, 34.0) - 1.002615e+26*R_pow(x, 36.0) + 3.414310e+26*R_pow(x, 38.0) - 1.015538e+27*R_pow(x, 40.0) + 2.644410e+27*R_pow(x, 42.0) - 6.037976e+27*R_pow(x, 44.0) + 1.209929e+28*R_pow(x, 46.0) - 2.128102e+28*R_pow(x, 48.0) + 3.283357e+28*R_pow(x, 50.0) - 4.437236e+28*R_pow(x, 52.0) + 5.240342e+28*R_pow(x, 54.0) - 5.390066e+28*R_pow(x, 56.0) + 4.806387e+28*R_pow(x, 58.0) - 3.693043e+28*R_pow(x, 60.0) + 2.425573e+28*R_pow(x, 62.0) - 1.347541e+28*R_pow(x, 64.0) + 6.244548e+27*R_pow(x, 66.0) - 2.368433e+27*R_pow(x, 68.0) + 7.159237e+26*R_pow(x, 70.0) - 1.658165e+26*R_pow(x, 72.0) + 2.762584e+25*R_pow(x, 74.0) - 2.946757e+24*R_pow(x, 76.0) + 1.511157e+23*R_pow(x, 78.0);
    }
    break;
  case 79:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -7.900000e+01*x + 8.216000e+04*R_pow(x, 3.0) - 2.560106e+07*R_pow(x, 5.0) + 3.788956e+09*R_pow(x, 7.0) - 3.258502e+11*R_pow(x, 9.0) + 1.824761e+13*R_pow(x, 11.0) - 7.158679e+14*R_pow(x, 13.0) + 2.069881e+16*R_pow(x, 15.0) - 4.578090e+17*R_pow(x, 17.0) + 7.967482e+18*R_pow(x, 19.0) - 1.115448e+20*R_pow(x, 21.0) + 1.278576e+21*R_pow(x, 23.0) - 1.217205e+22*R_pow(x, 25.0) + 9.737636e+22*R_pow(x, 27.0) - 6.610080e+23*R_pow(x, 29.0) + 3.838111e+24*R_pow(x, 31.0) - 1.919056e+25*R_pow(x, 33.0) + 8.308382e+25*R_pow(x, 35.0) - 3.128742e+26*R_pow(x, 37.0) + 1.028558e+27*R_pow(x, 39.0) - 2.960240e+27*R_pow(x, 41.0) + 7.474361e+27*R_pow(x, 43.0) - 1.657949e+28*R_pow(x, 45.0) + 3.233078e+28*R_pow(x, 47.0) - 5.542419e+28*R_pow(x, 49.0) + 8.346230e+28*R_pow(x, 51.0) - 1.102332e+29*R_pow(x, 53.0) + 1.273806e+29*R_pow(x, 55.0) - 1.283384e+29*R_pow(x, 57.0) + 1.122117e+29*R_pow(x, 59.0) - 8.461865e+28*R_pow(x, 61.0) + 5.459268e+28*R_pow(x, 63.0) - 2.981600e+28*R_pow(x, 65.0) + 1.359318e+28*R_pow(x, 67.0) - 5.075716e+27*R_pow(x, 69.0) + 1.511481e+27*R_pow(x, 71.0) - 3.450869e+26*R_pow(x, 73.0) + 5.670618e+25*R_pow(x, 75.0) - 5.969071e+24*R_pow(x, 77.0) + 3.022315e+23*R_pow(x, 79.0);
    }
    break;
  case 80:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 3.200000e+03*R_pow(x, 2.0) + 1.705600e+06*R_pow(x, 4.0) - 3.629517e+08*R_pow(x, 6.0) + 4.124687e+10*R_pow(x, 8.0) - 2.903779e+12*R_pow(x, 10.0) + 1.385895e+14*R_pow(x, 12.0) - 4.763823e+15*R_pow(x, 14.0) + 1.231448e+17*R_pow(x, 16.0) - 2.472555e+18*R_pow(x, 18.0) + 3.953485e+19*R_pow(x, 20.0) - 5.134396e+20*R_pow(x, 22.0) + 5.502733e+21*R_pow(x, 24.0) - 4.930449e+22*R_pow(x, 26.0) + 3.733054e+23*R_pow(x, 28.0) - 2.409751e+24*R_pow(x, 30.0) + 1.336051e+25*R_pow(x, 32.0) - 6.401615e+25*R_pow(x, 34.0) + 2.664291e+26*R_pow(x, 36.0) - 9.671794e+26*R_pow(x, 38.0) + 3.072655e+27*R_pow(x, 40.0) - 8.564891e+27*R_pow(x, 42.0) + 2.098670e+28*R_pow(x, 44.0) - 4.525827e+28*R_pow(x, 46.0) + 8.594257e+28*R_pow(x, 48.0) - 1.436819e+29*R_pow(x, 50.0) + 2.112970e+29*R_pow(x, 52.0) - 2.728699e+29*R_pow(x, 54.0) + 3.086619e+29*R_pow(x, 56.0) - 3.047406e+29*R_pow(x, 58.0) + 2.613538e+29*R_pow(x, 60.0) - 1.934930e+29*R_pow(x, 62.0) + 1.226608e+29*R_pow(x, 64.0) - 6.587655e+28*R_pow(x, 66.0) + 2.955480e+28*R_pow(x, 68.0) - 1.086736e+28*R_pow(x, 70.0) + 3.188778e+27*R_pow(x, 72.0) - 7.177997e+26*R_pow(x, 74.0) + 1.163591e+26*R_pow(x, 76.0) - 1.208926e+25*R_pow(x, 78.0) + 6.044629e+23*R_pow(x, 80.0);
    }
    break;
  case 81:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 8.100000e+01*x - 8.856000e+04*R_pow(x, 3.0) + 2.901226e+07*R_pow(x, 5.0) - 4.514860e+09*R_pow(x, 7.0) + 4.083440e+11*R_pow(x, 9.0) - 2.405517e+13*R_pow(x, 11.0) + 9.930469e+14*R_pow(x, 13.0) - 3.022645e+16*R_pow(x, 15.0) + 7.040986e+17*R_pow(x, 17.0) - 1.291259e+19*R_pow(x, 19.0) + 1.906144e+20*R_pow(x, 21.0) - 2.305455e+21*R_pow(x, 23.0) + 2.317751e+22*R_pow(x, 25.0) - 1.959853e+23*R_pow(x, 27.0) + 1.407619e+24*R_pow(x, 29.0) - 8.657613e+24*R_pow(x, 31.0) + 4.591158e+25*R_pow(x, 33.0) - 2.111161e+26*R_pow(x, 35.0) + 8.457324e+26*R_pow(x, 37.0) - 2.962917e+27*R_pow(x, 39.0) + 9.105549e+27*R_pow(x, 41.0) - 2.460414e+28*R_pow(x, 43.0) + 5.855289e+28*R_pow(x, 45.0) - 1.228473e+29*R_pow(x, 47.0) + 2.273093e+29*R_pow(x, 49.0) - 3.708262e+29*R_pow(x, 51.0) + 5.328272e+29*R_pow(x, 53.0) - 6.731204e+29*R_pow(x, 55.0) + 7.456622e+29*R_pow(x, 57.0) - 7.216929e+29*R_pow(x, 59.0) + 6.073263e+29*R_pow(x, 61.0) - 4.415788e+29*R_pow(x, 63.0) + 2.751375e+29*R_pow(x, 65.0) - 1.453463e+29*R_pow(x, 67.0) + 6.418532e+28*R_pow(x, 69.0) - 2.324619e+28*R_pow(x, 71.0) + 6.722643e+27*R_pow(x, 73.0) - 1.492306e+27*R_pow(x, 75.0) + 2.386873e+26*R_pow(x, 77.0) - 2.448075e+25*R_pow(x, 79.0) + 1.208926e+24*R_pow(x, 81.0);
    }
    break;
  case 82:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 3.362000e+03*R_pow(x, 2.0) - 1.882720e+06*R_pow(x, 4.0) + 4.209762e+08*R_pow(x, 6.0) - 5.027659e+10*R_pow(x, 8.0) + 3.720467e+12*R_pow(x, 10.0) - 1.866998e+14*R_pow(x, 12.0) + 6.749916e+15*R_pow(x, 14.0) - 1.835977e+17*R_pow(x, 16.0) + 3.880752e+18*R_pow(x, 18.0) - 6.536003e+19*R_pow(x, 20.0) + 8.946685e+20*R_pow(x, 22.0) - 1.011364e+22*R_pow(x, 24.0) + 9.565951e+22*R_pow(x, 26.0) - 7.652761e+23*R_pow(x, 28.0) + 5.224988e+24*R_pow(x, 30.0) - 3.067574e+25*R_pow(x, 32.0) + 1.558393e+26*R_pow(x, 34.0) - 6.886614e+26*R_pow(x, 36.0) + 2.658644e+27*R_pow(x, 38.0) - 8.998488e+27*R_pow(x, 40.0) + 2.677599e+28*R_pow(x, 42.0) - 7.019498e+28*R_pow(x, 44.0) + 1.623640e+29*R_pow(x, 46.0) - 3.316372e+29*R_pow(x, 48.0) + 5.983006e+29*R_pow(x, 50.0) - 9.529493e+29*R_pow(x, 52.0) + 1.338524e+30*R_pow(x, 54.0) - 1.654903e+30*R_pow(x, 56.0) + 1.796065e+30*R_pow(x, 58.0) - 1.704740e+30*R_pow(x, 60.0) + 1.408146e+30*R_pow(x, 62.0) - 1.005818e+30*R_pow(x, 64.0) + 6.161516e+29*R_pow(x, 66.0) - 3.202474e+29*R_pow(x, 68.0) + 1.392380e+29*R_pow(x, 70.0) - 4.968116e+28*R_pow(x, 72.0) + 1.416309e+28*R_pow(x, 74.0) - 3.100970e+27*R_pow(x, 76.0) + 4.894638e+26*R_pow(x, 78.0) - 4.956596e+25*R_pow(x, 80.0) + 2.417852e+24*R_pow(x, 82.0);
    }
    break;
  case 83:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -8.300000e+01*x + 9.528400e+04*R_pow(x, 3.0) - 3.277770e+07*R_pow(x, 5.0) + 5.356812e+09*R_pow(x, 7.0) - 5.088971e+11*R_pow(x, 9.0) + 3.149611e+13*R_pow(x, 11.0) - 1.366446e+15*R_pow(x, 13.0) + 4.372629e+16*R_pow(x, 15.0) - 1.071294e+18*R_pow(x, 17.0) + 2.067410e+19*R_pow(x, 19.0) - 3.213345e+20*R_pow(x, 21.0) + 4.094792e+21*R_pow(x, 23.0) - 4.340480e+22*R_pow(x, 25.0) + 3.873044e+23*R_pow(x, 27.0) - 2.938171e+24*R_pow(x, 29.0) + 1.910759e+25*R_pow(x, 31.0) - 1.072631e+26*R_pow(x, 33.0) + 5.227947e+26*R_pow(x, 35.0) - 2.223055e+27*R_pow(x, 37.0) + 8.280205e+27*R_pow(x, 39.0) - 2.710253e+28*R_pow(x, 41.0) + 7.815612e+28*R_pow(x, 43.0) - 1.989429e+29*R_pow(x, 45.0) + 4.475754e+29*R_pow(x, 47.0) - 8.905837e+29*R_pow(x, 49.0) + 1.567427e+30*R_pow(x, 51.0) - 2.438726e+30*R_pow(x, 53.0) + 3.350169e+30*R_pow(x, 55.0) - 4.055468e+30*R_pow(x, 57.0) + 4.313823e+30*R_pow(x, 59.0) - 4.016806e+30*R_pow(x, 61.0) + 3.257870e+30*R_pow(x, 63.0) - 2.286774e+30*R_pow(x, 65.0) + 1.377650e+30*R_pow(x, 67.0) - 7.046801e+29*R_pow(x, 69.0) + 3.017222e+29*R_pow(x, 71.0) - 1.060850e+29*R_pow(x, 73.0) + 2.981848e+28*R_pow(x, 75.0) - 6.440628e+27*R_pow(x, 77.0) + 1.003408e+27*R_pow(x, 79.0) - 1.003408e+26*R_pow(x, 81.0) + 4.835703e+24*R_pow(x, 83.0);
    }
    break;
  case 84:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 3.528000e+03*R_pow(x, 2.0) + 2.073288e+06*R_pow(x, 4.0) - 4.865316e+08*R_pow(x, 6.0) + 6.099021e+10*R_pow(x, 8.0) - 4.738262e+12*R_pow(x, 10.0) + 2.496920e+14*R_pow(x, 12.0) - 9.482809e+15*R_pow(x, 14.0) + 2.710503e+17*R_pow(x, 16.0) - 6.023340e+18*R_pow(x, 18.0) + 1.067082e+20*R_pow(x, 20.0) - 1.537338e+21*R_pow(x, 22.0) + 1.830323e+22*R_pow(x, 24.0) - 1.824691e+23*R_pow(x, 26.0) + 1.539885e+24*R_pow(x, 28.0) - 1.110133e+25*R_pow(x, 30.0) + 6.889092e+25*R_pow(x, 32.0) - 3.703654e+26*R_pow(x, 34.0) + 1.734251e+27*R_pow(x, 36.0) - 7.104755e+27*R_pow(x, 38.0) + 2.555890e+28*R_pow(x, 40.0) - 8.098104e+28*R_pow(x, 42.0) + 2.265072e+29*R_pow(x, 44.0) - 5.602498e+29*R_pow(x, 46.0) + 1.226788e+30*R_pow(x, 48.0) - 2.379468e+30*R_pow(x, 50.0) + 4.087804e+30*R_pow(x, 52.0) - 6.215976e+30*R_pow(x, 54.0) + 8.355240e+30*R_pow(x, 56.0) - 9.907000e+30*R_pow(x, 58.0) + 1.033239e+31*R_pow(x, 60.0) - 9.441757e+30*R_pow(x, 62.0) + 7.521558e+30*R_pow(x, 64.0) - 5.189700e+30*R_pow(x, 66.0) + 3.075546e+30*R_pow(x, 68.0) - 1.548598e+30*R_pow(x, 70.0) + 6.531255e+29*R_pow(x, 72.0) - 2.263330e+29*R_pow(x, 74.0) + 6.273792e+28*R_pow(x, 76.0) - 1.337072e+28*R_pow(x, 78.0) + 2.056383e+27*R_pow(x, 80.0) - 2.030995e+26*R_pow(x, 82.0) + 9.671407e+24*R_pow(x, 84.0);
    }
    break;
  case 85:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 8.500000e+01*x - 1.023400e+05*R_pow(x, 3.0) + 3.692427e+07*R_pow(x, 5.0) - 6.329875e+09*R_pow(x, 7.0) + 6.308776e+11*R_pow(x, 9.0) - 4.097263e+13*R_pow(x, 11.0) + 1.865831e+15*R_pow(x, 13.0) - 6.269191e+16*R_pow(x, 15.0) + 1.613395e+18*R_pow(x, 17.0) - 3.272078e+19*R_pow(x, 19.0) + 5.347510e+20*R_pow(x, 21.0) - 7.169467e+21*R_pow(x, 23.0) + 8.001126e+22*R_pow(x, 25.0) - 7.522426e+23*R_pow(x, 27.0) + 6.017941e+24*R_pow(x, 29.0) - 4.131025e+25*R_pow(x, 31.0) + 2.450449e+26*R_pow(x, 33.0) - 1.263526e+27*R_pow(x, 35.0) + 5.691557e+27*R_pow(x, 37.0) - 2.248971e+28*R_pow(x, 39.0) + 7.822032e+28*R_pow(x, 41.0) - 2.401182e+29*R_pow(x, 43.0) + 6.519573e+29*R_pow(x, 45.0) - 1.568075e+30*R_pow(x, 47.0) + 3.344160e+30*R_pow(x, 49.0) - 6.326363e+30*R_pow(x, 51.0) + 1.061433e+31*R_pow(x, 53.0) - 1.578212e+31*R_pow(x, 55.0) + 2.076595e+31*R_pow(x, 57.0) - 2.412782e+31*R_pow(x, 59.0) + 2.468158e+31*R_pow(x, 61.0) - 2.214138e+31*R_pow(x, 63.0) + 1.732989e+31*R_pow(x, 65.0) - 1.175705e+31*R_pow(x, 67.0) + 6.855773e+30*R_pow(x, 69.0) - 3.398918e+30*R_pow(x, 71.0) + 1.412336e+30*R_pow(x, 73.0) - 4.824845e+29*R_pow(x, 75.0) + 1.319165e+29*R_pow(x, 77.0) - 2.774485e+28*R_pow(x, 79.0) + 4.213106e+27*R_pow(x, 81.0) - 4.110348e+26*R_pow(x, 83.0) + 1.934281e+25*R_pow(x, 85.0);
    }
    break;
  case 86:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 3.698000e+03*R_pow(x, 2.0) - 2.277968e+06*R_pow(x, 4.0) + 5.603801e+08*R_pow(x, 6.0) - 7.364996e+10*R_pow(x, 8.0) + 6.000017e+12*R_pow(x, 10.0) - 3.316373e+14*R_pow(x, 12.0) + 1.321447e+16*R_pow(x, 14.0) - 3.964341e+17*R_pow(x, 16.0) + 9.250129e+18*R_pow(x, 18.0) - 1.721498e+20*R_pow(x, 20.0) + 2.606839e+21*R_pow(x, 22.0) - 3.264216e+22*R_pow(x, 24.0) + 3.424916e+23*R_pow(x, 26.0) - 3.044370e+24*R_pow(x, 28.0) + 2.313721e+25*R_pow(x, 30.0) - 1.515114e+26*R_pow(x, 32.0) + 8.604552e+26*R_pow(x, 34.0) - 4.261302e+27*R_pow(x, 36.0) + 1.848787e+28*R_pow(x, 38.0) - 7.053833e+28*R_pow(x, 40.0) + 2.374217e+29*R_pow(x, 42.0) - 7.067436e+29*R_pow(x, 44.0) + 1.864164e+30*R_pow(x, 46.0) - 4.362938e+30*R_pow(x, 48.0) + 9.067788e+30*R_pow(x, 50.0) - 1.674053e+31*R_pow(x, 52.0) + 2.744464e+31*R_pow(x, 54.0) - 3.991948e+31*R_pow(x, 56.0) + 5.143890e+31*R_pow(x, 58.0) - 5.858803e+31*R_pow(x, 60.0) + 5.880491e+31*R_pow(x, 62.0) - 5.180433e+31*R_pow(x, 64.0) + 3.984948e+31*R_pow(x, 66.0) - 2.658965e+31*R_pow(x, 68.0) + 1.526014e+31*R_pow(x, 70.0) - 7.450962e+30*R_pow(x, 72.0) + 3.051005e+30*R_pow(x, 74.0) - 1.027707e+30*R_pow(x, 76.0) + 2.772037e+29*R_pow(x, 78.0) - 5.754608e+28*R_pow(x, 80.0) + 8.629313e+27*R_pow(x, 82.0) - 8.317410e+26*R_pow(x, 84.0) + 3.868563e+25*R_pow(x, 86.0);
    }
    break;
  case 87:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -8.700000e+01*x + 1.097360e+05*R_pow(x, 3.0) - 4.148021e+07*R_pow(x, 5.0) + 7.450635e+09*R_pow(x, 7.0) - 7.781775e+11*R_pow(x, 9.0) + 5.297266e+13*R_pow(x, 11.0) - 2.529105e+15*R_pow(x, 13.0) + 8.912085e+16*R_pow(x, 15.0) - 2.406263e+18*R_pow(x, 17.0) + 5.122103e+19*R_pow(x, 19.0) - 8.790505e+20*R_pow(x, 21.0) + 1.238315e+22*R_pow(x, 23.0) - 1.452956e+23*R_pow(x, 25.0) + 1.437226e+24*R_pow(x, 27.0) - 1.210668e+25*R_pow(x, 29.0) + 8.758467e+25*R_pow(x, 31.0) - 5.480677e+26*R_pow(x, 33.0) + 2.984436e+27*R_pow(x, 35.0) - 1.421416e+28*R_pow(x, 37.0) + 5.946545e+28*R_pow(x, 39.0) - 2.192970e+29*R_pow(x, 41.0) + 7.149616e+29*R_pow(x, 43.0) - 2.065445e+30*R_pow(x, 45.0) + 5.296404e+30*R_pow(x, 47.0) - 1.207004e+31*R_pow(x, 49.0) + 2.446194e+31*R_pow(x, 51.0) - 4.409540e+31*R_pow(x, 53.0) + 7.067141e+31*R_pow(x, 55.0) - 1.006049e+32*R_pow(x, 57.0) + 1.270056e+32*R_pow(x, 59.0) - 1.418576e+32*R_pow(x, 61.0) + 1.397512e+32*R_pow(x, 63.0) - 1.209385e+32*R_pow(x, 65.0) + 9.145601e+31*R_pow(x, 67.0) - 6.003506e+31*R_pow(x, 69.0) + 3.391921e+31*R_pow(x, 71.0) - 1.631426e+31*R_pow(x, 73.0) + 6.584494e+30*R_pow(x, 75.0) - 2.187330e+30*R_pow(x, 77.0) + 5.821522e+29*R_pow(x, 79.0) - 1.193053e+29*R_pow(x, 81.0) + 1.766966e+28*R_pow(x, 83.0) - 1.682825e+27*R_pow(x, 85.0) + 7.737125e+25*R_pow(x, 87.0);
    }
    break;
  case 88:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 3.872000e+03*R_pow(x, 2.0) + 2.497440e+06*R_pow(x, 4.0) - 6.433405e+08*R_pow(x, 6.0) + 8.855123e+10*R_pow(x, 8.0) - 7.556372e+12*R_pow(x, 10.0) + 4.375826e+14*R_pow(x, 12.0) - 1.827268e+16*R_pow(x, 14.0) + 5.746758e+17*R_pow(x, 16.0) - 1.406265e+19*R_pow(x, 18.0) + 2.745918e+20*R_pow(x, 20.0) - 4.364940e+21*R_pow(x, 22.0) + 5.740846e+22*R_pow(x, 24.0) - 6.330828e+23*R_pow(x, 26.0) + 5.918822e+24*R_pow(x, 28.0) - 4.735057e+25*R_pow(x, 30.0) + 3.266808e+26*R_pow(x, 32.0) - 1.956591e+27*R_pow(x, 34.0) + 1.023017e+28*R_pow(x, 36.0) - 4.691619e+28*R_pow(x, 38.0) + 1.894692e+29*R_pow(x, 40.0) - 6.760156e+29*R_pow(x, 42.0) + 2.136667e+30*R_pow(x, 44.0) - 5.995053e+30*R_pow(x, 46.0) + 1.495575e+31*R_pow(x, 48.0) - 3.320786e+31*R_pow(x, 50.0) + 6.566441e+31*R_pow(x, 52.0) - 1.156354e+32*R_pow(x, 54.0) + 1.812623e+32*R_pow(x, 56.0) - 2.526487e+32*R_pow(x, 58.0) + 3.125993e+32*R_pow(x, 60.0) - 3.425202e+32*R_pow(x, 62.0) + 3.313067e+32*R_pow(x, 64.0) - 2.817266e+32*R_pow(x, 66.0) + 2.095017e+32*R_pow(x, 68.0) - 1.353303e+32*R_pow(x, 70.0) + 7.528938e+31*R_pow(x, 72.0) - 3.567953e+31*R_pow(x, 74.0) + 1.419670e+31*R_pow(x, 76.0) - 4.651864e+30*R_pow(x, 78.0) + 1.221850e+30*R_pow(x, 80.0) - 2.472398e+29*R_pow(x, 82.0) + 3.617106e+28*R_pow(x, 84.0) - 3.404335e+27*R_pow(x, 86.0) + 1.547425e+26*R_pow(x, 88.0);
    }
    break;
  case 89:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 8.900000e+01*x - 1.174800e+05*R_pow(x, 3.0) + 4.647509e+07*R_pow(x, 5.0) - 8.737317e+09*R_pow(x, 7.0) + 9.552799e+11*R_pow(x, 9.0) - 6.808541e+13*R_pow(x, 11.0) + 3.404270e+15*R_pow(x, 13.0) - 1.256662e+17*R_pow(x, 15.0) + 3.555614e+18*R_pow(x, 17.0) - 7.934634e+19*R_pow(x, 19.0) + 1.428234e+21*R_pow(x, 21.0) - 2.111303e+22*R_pow(x, 23.0) + 2.601125e+23*R_pow(x, 25.0) - 2.703391e+24*R_pow(x, 27.0) + 2.394432e+25*R_pow(x, 29.0) - 1.822858e+26*R_pow(x, 31.0) + 1.201429e+27*R_pow(x, 33.0) - 6.897617e+27*R_pow(x, 35.0) + 3.467451e+28*R_pow(x, 37.0) - 1.532978e+29*R_pow(x, 39.0) + 5.982354e+29*R_pow(x, 41.0) - 2.066993e+30*R_pow(x, 43.0) + 6.338778e+30*R_pow(x, 45.0) - 1.728651e+31*R_pow(x, 47.0) + 4.198153e+31*R_pow(x, 49.0) - 9.087766e+31*R_pow(x, 51.0) + 1.754242e+32*R_pow(x, 53.0) - 3.019423e+32*R_pow(x, 55.0) + 4.631295e+32*R_pow(x, 57.0) - 6.323031e+32*R_pow(x, 59.0) + 7.670562e+32*R_pow(x, 61.0) - 8.247916e+32*R_pow(x, 63.0) + 7.835520e+32*R_pow(x, 65.0) - 6.549091e+32*R_pow(x, 67.0) + 4.790384e+32*R_pow(x, 69.0) - 3.045797e+32*R_pow(x, 71.0) + 1.668930e+32*R_pow(x, 73.0) - 7.794355e+31*R_pow(x, 75.0) + 3.058072e+31*R_pow(x, 77.0) - 9.885881e+30*R_pow(x, 79.0) + 2.563006e+30*R_pow(x, 81.0) - 5.121493e+29*R_pow(x, 83.0) + 7.402495e+28*R_pow(x, 85.0) - 6.886041e+27*R_pow(x, 87.0) + 3.094850e+26*R_pow(x, 89.0);
    }
    break;
  case 90:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 4.050000e+03*R_pow(x, 2.0) - 2.732400e+06*R_pow(x, 4.0) + 7.362907e+08*R_pow(x, 6.0) - 1.060259e+11*R_pow(x, 8.0) + 9.466932e+12*R_pow(x, 10.0) - 5.737534e+14*R_pow(x, 12.0) + 2.508122e+16*R_pow(x, 14.0) - 8.260082e+17*R_pow(x, 16.0) + 2.117388e+19*R_pow(x, 18.0) - 4.332845e+20*R_pow(x, 20.0) + 7.221409e+21*R_pow(x, 22.0) - 9.963451e+22*R_pow(x, 24.0) + 1.153308e+24*R_pow(x, 26.0) - 1.132560e+25*R_pow(x, 28.0) + 9.523922e+25*R_pow(x, 30.0) - 6.912524e+26*R_pow(x, 32.0) + 4.359449e+27*R_pow(x, 34.0) - 2.402541e+28*R_pow(x, 36.0) + 1.162652e+29*R_pow(x, 38.0) - 4.960649e+29*R_pow(x, 40.0) + 1.872487e+30*R_pow(x, 42.0) - 6.270653e+30*R_pow(x, 44.0) + 1.867261e+31*R_pow(x, 46.0) - 4.952877e+31*R_pow(x, 48.0) + 1.171709e+32*R_pow(x, 50.0) - 2.474197e+32*R_pow(x, 52.0) + 4.664839e+32*R_pow(x, 54.0) - 7.851469e+32*R_pow(x, 56.0) + 1.178908e+33*R_pow(x, 58.0) - 1.577205e+33*R_pow(x, 60.0) + 1.876633e+33*R_pow(x, 62.0) - 1.980890e+33*R_pow(x, 64.0) + 1.848831e+33*R_pow(x, 66.0) - 1.519320e+33*R_pow(x, 68.0) + 1.093407e+33*R_pow(x, 70.0) - 6.844489e+32*R_pow(x, 72.0) + 3.694656e+32*R_pow(x, 74.0) - 1.700838e+32*R_pow(x, 76.0) + 6.581331e+31*R_pow(x, 78.0) - 2.099361e+31*R_pow(x, 80.0) + 5.373252e+30*R_pow(x, 82.0) - 1.060470e+30*R_pow(x, 84.0) + 1.514542e+29*R_pow(x, 86.0) - 1.392683e+28*R_pow(x, 88.0) + 6.189700e+26*R_pow(x, 90.0);
    }
    break;
  case 91:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -9.100000e+01*x + 1.255800e+05*R_pow(x, 3.0) - 5.193989e+07*R_pow(x, 5.0) + 1.020990e+10*R_pow(x, 7.0) - 1.167332e+12*R_pow(x, 9.0) + 8.701927e+13*R_pow(x, 11.0) - 4.551777e+15*R_pow(x, 13.0) + 1.758287e+17*R_pow(x, 15.0) - 5.207631e+18*R_pow(x, 17.0) + 1.216941e+20*R_pow(x, 19.0) - 2.294803e+21*R_pow(x, 21.0) + 3.555584e+22*R_pow(x, 23.0) - 4.593815e+23*R_pow(x, 25.0) + 5.010007e+24*R_pow(x, 27.0) - 4.659553e+25*R_pow(x, 29.0) + 3.727643e+26*R_pow(x, 31.0) - 2.583934e+27*R_pow(x, 33.0) + 1.561652e+28*R_pow(x, 35.0) - 8.272533e+28*R_pow(x, 37.0) + 3.858282e+29*R_pow(x, 39.0) - 1.590365e+30*R_pow(x, 41.0) + 5.811966e+30*R_pow(x, 43.0) - 1.888008e+31*R_pow(x, 45.0) + 5.463173e+31*R_pow(x, 47.0) - 1.410391e+32*R_pow(x, 49.0) + 3.252195e+32*R_pow(x, 51.0) - 6.702637e+32*R_pow(x, 53.0) + 1.234910e+33*R_pow(x, 55.0) - 2.033423e+33*R_pow(x, 57.0) + 2.990119e+33*R_pow(x, 59.0) - 3.921467e+33*R_pow(x, 61.0) + 4.578057e+33*R_pow(x, 63.0) - 4.745332e+33*R_pow(x, 65.0) + 4.352570e+33*R_pow(x, 67.0) - 3.517678e+33*R_pow(x, 69.0) + 2.491394e+33*R_pow(x, 71.0) - 1.535791e+33*R_pow(x, 73.0) + 8.168746e+32*R_pow(x, 75.0) - 3.707483e+32*R_pow(x, 77.0) + 1.415125e+32*R_pow(x, 79.0) - 4.455023e+31*R_pow(x, 81.0) + 1.125865e+31*R_pow(x, 83.0) - 2.194964e+30*R_pow(x, 85.0) + 3.097945e+29*R_pow(x, 87.0) - 2.816314e+28*R_pow(x, 89.0) + 1.237940e+27*R_pow(x, 91.0);
    }
    break;
  case 92:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 4.232000e+03*R_pow(x, 2.0) + 2.983560e+06*R_pow(x, 4.0) - 8.401705e+08*R_pow(x, 6.0) + 1.264457e+11*R_pow(x, 8.0) - 1.180159e+13*R_pow(x, 10.0) + 7.477920e+14*R_pow(x, 12.0) - 3.418478e+16*R_pow(x, 14.0) + 1.177666e+18*R_pow(x, 16.0) - 3.158915e+19*R_pow(x, 18.0) + 6.766728e+20*R_pow(x, 20.0) - 1.181102e+22*R_pow(x, 22.0) + 1.707462e+23*R_pow(x, 24.0) - 2.072071e+24*R_pow(x, 26.0) + 2.134562e+25*R_pow(x, 28.0) - 1.884303e+26*R_pow(x, 30.0) + 1.436781e+27*R_pow(x, 32.0) - 9.527317e+27*R_pow(x, 34.0) + 5.525844e+28*R_pow(x, 36.0) - 2.817159e+29*R_pow(x, 38.0) + 1.267721e+30*R_pow(x, 40.0) - 5.053217e+30*R_pow(x, 42.0) + 1.789458e+31*R_pow(x, 44.0) - 5.643278e+31*R_pow(x, 46.0) + 1.587922e+32*R_pow(x, 48.0) - 3.992490e+32*R_pow(x, 50.0) + 8.978587e+32*R_pow(x, 52.0) - 1.807011e+33*R_pow(x, 54.0) + 3.254967e+33*R_pow(x, 56.0) - 5.245754e+33*R_pow(x, 58.0) + 7.557443e+33*R_pow(x, 60.0) - 9.719566e+33*R_pow(x, 62.0) + 1.113700e+34*R_pow(x, 64.0) - 1.133949e+34*R_pow(x, 66.0) + 1.022446e+34*R_pow(x, 68.0) - 8.128764e+33*R_pow(x, 70.0) + 5.667237e+33*R_pow(x, 72.0) - 3.441047e+33*R_pow(x, 74.0) + 1.803833e+33*R_pow(x, 76.0) - 8.073099e+32*R_pow(x, 78.0) + 3.040186e+32*R_pow(x, 80.0) - 9.447371e+31*R_pow(x, 82.0) + 2.357778e+31*R_pow(x, 84.0) - 4.541383e+30*R_pow(x, 86.0) + 6.335158e+29*R_pow(x, 88.0) - 5.694524e+28*R_pow(x, 90.0) + 2.475880e+27*R_pow(x, 92.0);
    }
    break;
  case 93:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 9.300000e+01*x - 1.340440e+05*R_pow(x, 3.0) + 5.790701e+07*R_pow(x, 5.0) - 1.189024e+10*R_pow(x, 7.0) + 1.420223e+12*R_pow(x, 9.0) - 1.106225e+14*R_pow(x, 11.0) + 6.047361e+15*R_pow(x, 13.0) - 2.441982e+17*R_pow(x, 15.0) + 7.562962e+18*R_pow(x, 17.0) - 1.848724e+20*R_pow(x, 19.0) + 3.648149e+21*R_pow(x, 21.0) - 5.917788e+22*R_pow(x, 23.0) + 8.008739e+23*R_pow(x, 25.0) - 9.154149e+24*R_pow(x, 27.0) + 8.928677e+25*R_pow(x, 29.0) - 7.496248e+26*R_pow(x, 31.0) + 5.457496e+27*R_pow(x, 33.0) - 3.467115e+28*R_pow(x, 35.0) + 1.932422e+29*R_pow(x, 37.0) - 9.492600e+29*R_pow(x, 39.0) + 4.125808e+30*R_pow(x, 41.0) - 1.591840e+31*R_pow(x, 43.0) + 5.466925e+31*R_pow(x, 45.0) - 1.674973e+32*R_pow(x, 47.0) + 4.586235e+32*R_pow(x, 49.0) - 1.123718e+33*R_pow(x, 51.0) + 2.465981e+33*R_pow(x, 53.0) - 4.848932e+33*R_pow(x, 55.0) + 8.543357e+33*R_pow(x, 57.0) - 1.348163e+34*R_pow(x, 59.0) + 1.903635e+34*R_pow(x, 61.0) - 2.401719e+34*R_pow(x, 63.0) + 2.701934e+34*R_pow(x, 65.0) - 2.703156e+34*R_pow(x, 67.0) + 2.396660e+34*R_pow(x, 69.0) - 1.874892e+34*R_pow(x, 71.0) + 1.287026e+34*R_pow(x, 73.0) - 7.698969e+33*R_pow(x, 75.0) + 3.978414e+33*R_pow(x, 77.0) - 1.756132e+33*R_pow(x, 79.0) + 6.525874e+32*R_pow(x, 81.0) - 2.002061e+32*R_pow(x, 83.0) + 4.935052e+31*R_pow(x, 85.0) - 9.392561e+30*R_pow(x, 87.0) + 1.295195e+30*R_pow(x, 89.0) - 1.151284e+29*R_pow(x, 91.0) + 4.951760e+27*R_pow(x, 93.0);
    }
    break;
  case 94:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 4.418000e+03*R_pow(x, 2.0) - 3.251648e+06*R_pow(x, 4.0) + 9.559845e+08*R_pow(x, 6.0) - 1.502261e+11*R_pow(x, 8.0) + 1.464204e+13*R_pow(x, 10.0) - 9.690369e+14*R_pow(x, 12.0) + 4.627950e+16*R_pow(x, 14.0) - 1.666062e+18*R_pow(x, 16.0) + 4.671507e+19*R_pow(x, 18.0) - 1.046418e+21*R_pow(x, 20.0) + 1.910731e+22*R_pow(x, 22.0) - 2.891020e+23*R_pow(x, 24.0) + 3.673819e+24*R_pow(x, 26.0) - 3.965392e+25*R_pow(x, 28.0) + 3.670038e+26*R_pow(x, 30.0) - 2.936031e+27*R_pow(x, 32.0) + 2.044231e+28*R_pow(x, 34.0) - 1.246007e+29*R_pow(x, 36.0) + 6.682003e+29*R_pow(x, 38.0) - 3.166241e+30*R_pow(x, 40.0) + 1.330483e+31*R_pow(x, 42.0) - 4.973138e+31*R_pow(x, 44.0) + 1.657713e+32*R_pow(x, 46.0) - 4.937868e+32*R_pow(x, 48.0) + 1.316496e+33*R_pow(x, 50.0) - 3.145294e+33*R_pow(x, 52.0) + 6.738973e+33*R_pow(x, 54.0) - 1.295283e+34*R_pow(x, 56.0) + 2.233247e+34*R_pow(x, 58.0) - 3.452070e+34*R_pow(x, 60.0) + 4.779227e+34*R_pow(x, 62.0) - 5.917138e+34*R_pow(x, 64.0) + 6.537817e+34*R_pow(x, 66.0) - 6.428758e+34*R_pow(x, 68.0) + 5.606196e+34*R_pow(x, 70.0) - 4.316508e+34*R_pow(x, 72.0) + 2.918158e+34*R_pow(x, 74.0) - 1.720177e+34*R_pow(x, 76.0) + 8.764139e+33*R_pow(x, 78.0) - 3.816283e+33*R_pow(x, 80.0) + 1.399649e+33*R_pow(x, 82.0) - 4.239899e+32*R_pow(x, 84.0) + 1.032424e+32*R_pow(x, 86.0) - 1.941864e+31*R_pow(x, 88.0) + 2.647335e+30*R_pow(x, 90.0) - 2.327327e+29*R_pow(x, 92.0) + 9.903520e+27*R_pow(x, 94.0);
    }
    break;
  case 95:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -9.500000e+01*x + 1.428800e+05*R_pow(x, 3.0) - 6.441030e+07*R_pow(x, 5.0) + 1.380221e+10*R_pow(x, 7.0) - 1.720675e+12*R_pow(x, 9.0) + 1.399065e+14*R_pow(x, 11.0) - 7.985435e+15*R_pow(x, 13.0) + 3.367572e+17*R_pow(x, 15.0) - 1.089509e+19*R_pow(x, 17.0) + 2.783025e+20*R_pow(x, 19.0) - 5.740984e+21*R_pow(x, 21.0) + 9.739250e+22*R_pow(x, 23.0) - 1.379078e+24*R_pow(x, 25.0) + 1.650179e+25*R_pow(x, 27.0) - 1.685946e+26*R_pow(x, 29.0) + 1.483632e+27*R_pow(x, 31.0) - 1.132956e+28*R_pow(x, 33.0) + 7.555577e+28*R_pow(x, 35.0) - 4.424437e+29*R_pow(x, 37.0) + 2.285661e+30*R_pow(x, 39.0) - 1.045829e+31*R_pow(x, 41.0) + 4.252807e+31*R_pow(x, 43.0) - 1.541320e+32*R_pow(x, 45.0) + 4.990398e+32*R_pow(x, 47.0) - 1.446197e+33*R_pow(x, 49.0) + 3.756710e+33*R_pow(x, 51.0) - 8.756568e+33*R_pow(x, 53.0) + 1.832688e+34*R_pow(x, 55.0) - 3.444902e+34*R_pow(x, 57.0) + 5.814656e+34*R_pow(x, 59.0) - 8.807774e+34*R_pow(x, 61.0) + 1.196017e+35*R_pow(x, 63.0) - 1.453621e+35*R_pow(x, 65.0) + 1.577879e+35*R_pow(x, 67.0) - 1.525418e+35*R_pow(x, 69.0) + 1.308728e+35*R_pow(x, 71.0) - 9.920042e+34*R_pow(x, 73.0) + 6.606212e+34*R_pow(x, 75.0) - 3.838196e+34*R_pow(x, 77.0) + 1.928441e+34*R_pow(x, 79.0) - 8.285154e+33*R_pow(x, 81.0) + 2.999503e+33*R_pow(x, 83.0) - 8.973304e+32*R_pow(x, 85.0) + 2.158774e+32*R_pow(x, 87.0) - 4.013247e+31*R_pow(x, 89.0) + 5.409798e+30*R_pow(x, 91.0) - 4.704172e+29*R_pow(x, 93.0) + 1.980704e+28*R_pow(x, 95.0);
    }
    break;
  case 96:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 4.608000e+03*R_pow(x, 2.0) + 3.537408e+06*R_pow(x, 4.0) - 1.084805e+09*R_pow(x, 6.0) + 1.778306e+11*R_pow(x, 8.0) - 1.808339e+13*R_pow(x, 10.0) + 1.248850e+15*R_pow(x, 12.0) - 6.225037e+16*R_pow(x, 14.0) + 2.339576e+18*R_pow(x, 16.0) - 6.850524e+19*R_pow(x, 18.0) + 1.603023e+21*R_pow(x, 20.0) - 3.058928e+22*R_pow(x, 22.0) + 4.838870e+23*R_pow(x, 24.0) - 6.431974e+24*R_pow(x, 26.0) + 7.265749e+25*R_pow(x, 28.0) - 7.041930e+26*R_pow(x, 30.0) + 5.903296e+27*R_pow(x, 32.0) - 4.310142e+28*R_pow(x, 34.0) + 2.757123e+29*R_pow(x, 36.0) - 1.553088e+30*R_pow(x, 38.0) + 7.737562e+30*R_pow(x, 40.0) - 3.422141e+31*R_pow(x, 42.0) + 1.347875e+32*R_pow(x, 44.0) - 4.740353e+32*R_pow(x, 46.0) + 1.491866e+33*R_pow(x, 48.0) - 4.208890e+33*R_pow(x, 50.0) + 1.065871e+34*R_pow(x, 52.0) - 2.425211e+34*R_pow(x, 54.0) + 4.960659e+34*R_pow(x, 56.0) - 9.123051e+34*R_pow(x, 58.0) + 1.508138e+35*R_pow(x, 60.0) - 2.239478e+35*R_pow(x, 62.0) + 2.983748e+35*R_pow(x, 64.0) - 3.561024e+35*R_pow(x, 66.0) + 3.798634e+35*R_pow(x, 68.0) - 3.611455e+35*R_pow(x, 70.0) + 3.049108e+35*R_pow(x, 72.0) - 2.275824e+35*R_pow(x, 74.0) + 1.493260e+35*R_pow(x, 76.0) - 8.552805e+34*R_pow(x, 78.0) + 4.238510e+34*R_pow(x, 80.0) - 1.796996e+34*R_pow(x, 82.0) + 6.422996e+33*R_pow(x, 84.0) - 1.897903e+33*R_pow(x, 86.0) + 4.511734e+32*R_pow(x, 88.0) - 8.291227e+31*R_pow(x, 90.0) + 1.105233e+31*R_pow(x, 92.0) - 9.507380e+29*R_pow(x, 94.0) + 3.961408e+28*R_pow(x, 96.0);
    }
    break;
  case 97:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 9.700000e+01*x - 1.520960e+05*R_pow(x, 3.0) + 7.148512e+07*R_pow(x, 5.0) - 1.597182e+10*R_pow(x, 7.0) + 2.076336e+12*R_pow(x, 9.0) - 1.760733e+14*R_pow(x, 11.0) + 1.048313e+16*R_pow(x, 13.0) - 4.612579e+17*R_pow(x, 15.0) + 1.557424e+19*R_pow(x, 17.0) - 4.153130e+20*R_pow(x, 19.0) + 8.947029e+21*R_pow(x, 21.0) - 1.585711e+23*R_pow(x, 23.0) + 2.346852e+24*R_pow(x, 25.0) - 2.936573e+25*R_pow(x, 27.0) + 3.139096e+26*R_pow(x, 29.0) - 2.892019e+27*R_pow(x, 31.0) + 2.313615e+28*R_pow(x, 33.0) - 1.617586e+29*R_pow(x, 35.0) + 9.938683e+29*R_pow(x, 37.0) - 5.391836e+30*R_pow(x, 39.0) + 2.593342e+31*R_pow(x, 41.0) - 1.109709e+32*R_pow(x, 43.0) + 4.237071e+32*R_pow(x, 45.0) - 1.447110e+33*R_pow(x, 47.0) + 4.429930e+33*R_pow(x, 49.0) - 1.217449e+34*R_pow(x, 51.0) + 3.007399e+34*R_pow(x, 53.0) - 6.683110e+34*R_pow(x, 55.0) + 1.336622e+35*R_pow(x, 57.0) - 2.406076e+35*R_pow(x, 59.0) + 3.897054e+35*R_pow(x, 61.0) - 5.674973e+35*R_pow(x, 63.0) + 7.421118e+35*R_pow(x, 65.0) - 8.699927e+35*R_pow(x, 67.0) + 9.122685e+35*R_pow(x, 69.0) - 8.531638e+35*R_pow(x, 71.0) + 7.090220e+35*R_pow(x, 73.0) - 5.212270e+35*R_pow(x, 75.0) + 3.370340e+35*R_pow(x, 77.0) - 1.903405e+35*R_pow(x, 79.0) + 9.305536e+34*R_pow(x, 81.0) - 3.893942e+34*R_pow(x, 83.0) + 1.374332e+34*R_pow(x, 85.0) - 4.011684e+33*R_pow(x, 87.0) + 9.424793e+32*R_pow(x, 89.0) - 1.712343e+32*R_pow(x, 91.0) + 2.257507e+31*R_pow(x, 93.0) - 1.921283e+30*R_pow(x, 95.0) + 7.922816e+28*R_pow(x, 97.0);
    }
    break;
  case 98:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -1.000000e+00 + 4.802000e+03*R_pow(x, 2.0) - 3.841600e+06*R_pow(x, 4.0) + 1.227775e+09*R_pow(x, 6.0) - 2.097742e+11*R_pow(x, 8.0) + 2.223606e+13*R_pow(x, 10.0) - 1.600997e+15*R_pow(x, 12.0) + 8.321664e+16*R_pow(x, 14.0) - 3.262092e+18*R_pow(x, 16.0) + 9.965372e+19*R_pow(x, 18.0) - 2.433649e+21*R_pow(x, 20.0) + 4.848334e+22*R_pow(x, 22.0) - 8.010291e+23*R_pow(x, 24.0) + 1.112568e+25*R_pow(x, 26.0) - 1.313890e+26*R_pow(x, 28.0) + 1.332012e+27*R_pow(x, 30.0) - 1.168733e+28*R_pow(x, 32.0) + 8.937372e+28*R_pow(x, 34.0) - 5.992295e+29*R_pow(x, 36.0) + 3.540824e+30*R_pow(x, 38.0) - 1.852123e+31*R_pow(x, 40.0) + 8.608825e+31*R_pow(x, 42.0) - 3.567293e+32*R_pow(x, 44.0) + 1.321449e+33*R_pow(x, 46.0) - 4.386087e+33*R_pow(x, 48.0) + 1.306875e+34*R_pow(x, 50.0) - 3.500769e+34*R_pow(x, 52.0) + 8.440010e+34*R_pow(x, 54.0) - 1.832688e+35*R_pow(x, 56.0) + 3.585549e+35*R_pow(x, 58.0) - 6.320290e+35*R_pow(x, 60.0) + 1.003359e+36*R_pow(x, 62.0) - 1.433369e+36*R_pow(x, 64.0) + 1.840326e+36*R_pow(x, 66.0) - 2.119849e+36*R_pow(x, 68.0) + 2.185682e+36*R_pow(x, 70.0) - 2.011238e+36*R_pow(x, 72.0) + 1.645626e+36*R_pow(x, 74.0) - 1.191780e+36*R_pow(x, 76.0) + 7.595960e+35*R_pow(x, 78.0) - 4.230661e+35*R_pow(x, 80.0) + 2.040807e+35*R_pow(x, 82.0) - 8.430183e+34*R_pow(x, 84.0) + 2.938455e+34*R_pow(x, 86.0) - 8.474541e+33*R_pow(x, 88.0) + 1.967871e+33*R_pow(x, 90.0) - 3.535210e+32*R_pow(x, 92.0) + 4.610089e+31*R_pow(x, 94.0) - 3.882180e+30*R_pow(x, 96.0) + 1.584563e+29*R_pow(x, 98.0);
    }
    break;
  case 99:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = -9.900000e+01*x + 1.617000e+05*R_pow(x, 3.0) - 7.916832e+07*R_pow(x, 5.0) + 1.842737e+10*R_pow(x, 7.0) - 2.495885e+12*R_pow(x, 9.0) + 2.205455e+14*R_pow(x, 11.0) - 1.368513e+16*R_pow(x, 13.0) + 6.276912e+17*R_pow(x, 15.0) - 2.209842e+19*R_pow(x, 17.0) + 6.146205e+20*R_pow(x, 19.0) - 1.381433e+22*R_pow(x, 21.0) + 2.555377e+23*R_pow(x, 23.0) - 3.948910e+24*R_pow(x, 25.0) + 5.161709e+25*R_pow(x, 27.0) - 5.766875e+26*R_pow(x, 29.0) + 5.556043e+27*R_pow(x, 31.0) - 4.651081e+28*R_pow(x, 33.0) + 3.405061e+29*R_pow(x, 35.0) - 2.192327e+30*R_pow(x, 37.0) + 1.247348e+31*R_pow(x, 39.0) - 6.297588e+31*R_pow(x, 41.0) + 2.831474e+32*R_pow(x, 43.0) - 1.137166e+33*R_pow(x, 45.0) + 4.090009e+33*R_pow(x, 47.0) - 1.320210e+34*R_pow(x, 49.0) + 3.831199e+34*R_pow(x, 51.0) - 1.000894e+35*R_pow(x, 53.0) + 2.356313e+35*R_pow(x, 55.0) - 5.001998e+35*R_pow(x, 57.0) + 9.577174e+35*R_pow(x, 59.0) - 1.653763e+36*R_pow(x, 61.0) + 2.574214e+36*R_pow(x, 63.0) - 3.608850e+36*R_pow(x, 65.0) + 4.550645e+36*R_pow(x, 67.0) - 5.151966e+36*R_pow(x, 69.0) + 5.224529e+36*R_pow(x, 71.0) - 4.731499e+36*R_pow(x, 73.0) + 3.812480e+36*R_pow(x, 75.0) - 2.720594e+36*R_pow(x, 77.0) + 1.709533e+36*R_pow(x, 79.0) - 9.391876e+35*R_pow(x, 81.0) + 4.471008e+35*R_pow(x, 83.0) - 1.823470e+35*R_pow(x, 85.0) + 6.278078e+34*R_pow(x, 87.0) - 1.789156e+34*R_pow(x, 89.0) + 4.106976e+33*R_pow(x, 91.0) - 7.296171e+32*R_pow(x, 93.0) + 9.412306e+31*R_pow(x, 95.0) - 7.843588e+30*R_pow(x, 97.0) + 3.169127e+29*R_pow(x, 99.0);
    }
    break;
  case 100:
    for (int i = 0; i < xlen[0]; i++) {
     x = xin[i];
     xin[i] = 1.000000e+00 - 5.000000e+03*R_pow(x, 2.0) + 4.165000e+06*R_pow(x, 4.0) - 1.386112e+09*R_pow(x, 6.0) + 2.466289e+11*R_pow(x, 8.0) - 2.722783e+13*R_pow(x, 10.0) + 2.042088e+15*R_pow(x, 12.0) - 1.105869e+17*R_pow(x, 14.0) + 4.517475e+18*R_pow(x, 16.0) - 1.438506e+20*R_pow(x, 18.0) + 3.662890e+21*R_pow(x, 20.0) - 7.611199e+22*R_pow(x, 22.0) + 1.312105e+24*R_pow(x, 24.0) - 1.902350e+25*R_pow(x, 26.0) + 2.346231e+26*R_pow(x, 28.0) - 2.485387e+27*R_pow(x, 30.0) + 2.279942e+28*R_pow(x, 32.0) - 1.823953e+29*R_pow(x, 34.0) + 1.280242e+30*R_pow(x, 36.0) - 7.925479e+30*R_pow(x, 38.0) + 4.346820e+31*R_pow(x, 40.0) - 2.120400e+32*R_pow(x, 42.0) + 9.230241e+32*R_pow(x, 44.0) - 3.595781e+33*R_pow(x, 46.0) + 1.256611e+34*R_pow(x, 48.0) - 3.947296e+34*R_pow(x, 50.0) + 1.116317e+35*R_pow(x, 52.0) - 2.845789e+35*R_pow(x, 54.0) + 6.545314e+35*R_pow(x, 56.0) - 1.358954e+36*R_pow(x, 58.0) + 2.547464e+36*R_pow(x, 60.0) - 4.310885e+36*R_pow(x, 62.0) + 6.581798e+36*R_pow(x, 64.0) - 9.058027e+36*R_pow(x, 66.0) + 1.122114e+37*R_pow(x, 68.0) - 1.248961e+37*R_pow(x, 70.0) + 1.246030e+37*R_pow(x, 72.0) - 1.110862e+37*R_pow(x, 74.0) + 8.816739e+36*R_pow(x, 76.0) - 6.200784e+36*R_pow(x, 78.0) + 3.842131e+36*R_pow(x, 80.0) - 2.082456e+36*R_pow(x, 82.0) + 9.785034e+35*R_pow(x, 84.0) - 3.940785e+35*R_pow(x, 86.0) + 1.340361e+35*R_pow(x, 88.0) - 3.775099e+34*R_pow(x, 90.0) + 8.567474e+33*R_pow(x, 92.0) - 1.505335e+33*R_pow(x, 94.0) + 1.921283e+32*R_pow(x, 96.0) - 1.584563e+31*R_pow(x, 98.0) + 6.338253e+29*R_pow(x, 100.0);
    }
    break;
 
  default:
   Rf_warning("n =  101  but it cannot be greater than  100 , contact the author to increase that value");
}
 return;
}
}
