% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseDrugRestart.R
\name{addDrugRestart}
\alias{addDrugRestart}
\title{Add drug restart information as a column per follow-up period of interest.}
\usage{
addDrugRestart(
  cohort,
  switchCohortTable,
  switchCohortId = NULL,
  followUpDays = Inf,
  censorDate = NULL,
  incident = TRUE,
  nameStyle = "drug_restart_{follow_up_days}"
)
}
\arguments{
\item{cohort}{A cohort_table object.}

\item{switchCohortTable}{A cohort table in the cdm that contains possible
alternative treatments.}

\item{switchCohortId}{The cohort ids to be used from switchCohortTable. If
NULL all cohort definition ids are used.}

\item{followUpDays}{A vector of number of days to follow up. It can be
multiple values.}

\item{censorDate}{Name of a column that indicates the date to stop the
analysis, if NULL end of individuals observation is used.}

\item{incident}{Whether the switch treatment has to be incident (start after
discontinuation) or not (it can start before the discontinuation and last
till after).}

\item{nameStyle}{Character string to specify the nameStyle of the new columns.}
}
\value{
The cohort table given with additional columns with information on the
restart, switch and not exposed per follow-up period of interest.
}
\description{
Add drug restart information as a column per follow-up period of interest.
}
\examples{
\donttest{
library(DrugUtilisation)

cdm <- mockDrugUtilisation()

conceptlist <- list(acetaminophen = 1125360, metformin = c(1503297, 1503327))
cdm <- generateDrugUtilisationCohortSet(cdm = cdm,
                                        name = "switch_cohort",
                                        conceptSet = conceptlist)

cdm$cohort1 |>
  addDrugRestart(switchCohortTable = "switch_cohort")
}
}
