% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frechetUpperBoundCopula.R
\name{frechetUpperBound}
\alias{frechetUpperBound}
\alias{cFrechetUpperBound}
\alias{crFrechetUpperBound}
\title{Fréchet Upper Bound Copula}
\usage{
cFrechetUpperBound(u1, u2, ...)

crFrechetUpperBound(numberSimulations = 10000, seed = 42)
}
\arguments{
\item{u1, u2}{points at which to evaluate the copula.}

\item{...}{other parameters.}

\item{numberSimulations}{Number of simulations.}

\item{seed}{Simulation seed, 42 by default.}
}
\value{
Function :
  \itemize{
    \item \code{\link{cFrechetUpperBound}}  returns the value of the copula.
    \item \code{\link{crFrechetUpperBound}}  returns simulated values of the copula.
  }
}
\description{
Computes CDF and simulations of the Fréchet upper bound copula.
}
\details{
The Fréchet upper bound copula has CDF :
  \deqn{C(u_{1}, u_{2}) = \min(u_{1}, u_{2})}{C(u1, u2) = min(u1, u2)}
  for \eqn{u_{1}, u_{2} \in [0, 1]}{0 <= u1, u2 <= 1}.
}
\examples{
cFrechetUpperBound(u1 = .56, u2 = 0.4)

crFrechetUpperBound(numberSimulations = 10, seed = 42)

}
