% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bivariateClaytonCopula.R
\name{bivariateClayton}
\alias{bivariateClayton}
\alias{cBivariateClayton}
\alias{cdBivariateClayton}
\alias{crBivariateClayton}
\title{Bivariate Clayton Copula}
\usage{
cBivariateClayton(u1, u2, dependencyParameter, ...)

cdBivariateClayton(u1, u2, dependencyParameter, ...)

crBivariateClayton(numberSimulations = 10000, seed = 42, dependencyParameter)
}
\arguments{
\item{u1, u2}{points at which to evaluate the copula.}

\item{dependencyParameter}{correlation parameter.}

\item{...}{other parameters.}

\item{numberSimulations}{Number of simulations.}

\item{seed}{Simulation seed, 42 by default.}
}
\value{
Function :
  \itemize{
    \item \code{\link{cBivariateAMH}}  returns the value of the copula.
    \item \code{\link{cdBivariateAMH}}  returns the value of the density function associated to the copula.
  }
}
\description{
Computes CDF, PDF and simulations of the bivariate Clayton copula.
}
\details{
The bivariate Clayton copula has CDF :
}
\examples{
cBivariateClayton(u1 = .76, u2 = 0.4, dependencyParameter = 0.4)

cdBivariateClayton(u1 = .76, u2 = 0.4, dependencyParameter = 0.4)

crBivariateClayton(numberSimulations = 10, seed = 42, dependencyParameter = 0.2)

}
