% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bivariateCACopula.R
\name{bivariateCA}
\alias{bivariateCA}
\alias{cBivariateCA}
\alias{crBivariateCA}
\title{Bivariate Cuadras-Augé Copula}
\usage{
cBivariateCA(u1, u2, dependencyParameter, ...)

crBivariateCA(numberSimulations = 10000, seed = 42, dependencyParameter)
}
\arguments{
\item{u1, u2}{points at which to evaluate the copula.}

\item{dependencyParameter}{correlation parameter.}

\item{...}{other parameters.}

\item{numberSimulations}{Number of simulations.}

\item{seed}{Simulation seed, 42 by default.}
}
\value{
Function :
  \itemize{
    \item \code{\link{cBivariateCA}}  returns the value of the copula.
    \item \code{\link{crBivariateCA}}  returns simulated values of the copula.
  }
}
\description{
Computes CDF and simulations of the bivariate Cuadras-Augé copula.
}
\details{
The bivariate Cuadras-Augé copula has CDF :
  \deqn{C(u_{1}, u_{2}) = u_{1}u_{2}^{1 - \alpha} \times%
  \textbf{1}_{\{u_{1} \leq u_{2}\}} + u_{1}^{1 - \alpha}u_{2} \times%
  \textbf{1}_{\{u_{1} \geq u_{2}\}}}{C(u1, u2) = u1 u2^(1 - alpha) * %
  1_(u1 <= u2) + u1^(1 - alpha) u2 * 1_(u1 >= u2)}
for \eqn{u_{1}, u_{2}, \alpha \in [0, 1]}{0 <= u1, u2, alpha <= 1}.
It is the geometric mean of the independance and upper Fréchet bound copulas.
}
\examples{
cBivariateCA(u1 = .76, u2 = 0.4, dependencyParameter = 0.4)

crBivariateCA(numberSimulations = 10, seed = 42, dependencyParameter = 0.2)

}
