% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lnorm.R
\name{Lnorm}
\alias{Lnorm}
\alias{expValLnorm}
\alias{varLnorm}
\alias{kthMomentLnorm}
\alias{expValLimLnorm}
\alias{expValTruncLnorm}
\alias{stopLossLnorm}
\alias{meanExcessLnorm}
\alias{VatRLnorm}
\alias{TVatRLnorm}
\title{Lognormal Distribution}
\usage{
expValLnorm(meanlog, sdlog)

varLnorm(meanlog, sdlog)

kthMomentLnorm(k, meanlog, sdlog)

expValLimLnorm(d, meanlog, sdlog)

expValTruncLnorm(d, meanlog, sdlog, less.than.d = TRUE)

stopLossLnorm(d, meanlog, sdlog)

meanExcessLnorm(d, meanlog, sdlog)

VatRLnorm(kap, meanlog, sdlog)

TVatRLnorm(kap, meanlog, sdlog)
}
\arguments{
\item{meanlog}{location parameter \eqn{\mu}{mu}.}

\item{sdlog}{standard deviation \eqn{\sigma}{sigma}, must be positive.}

\item{k}{kth-moment.}

\item{d}{cut-off value.}

\item{less.than.d}{logical; if \code{TRUE} (default) truncated mean for values <= d, otherwise, for values > d.}

\item{kap}{probability.}
}
\value{
Function :
  \itemize{
    \item \code{\link{expValLnorm}}  gives the expected value.
    \item \code{\link{varLnorm}}  gives the variance.
    \item \code{\link{kthMomentLnorm}}  gives the kth moment.
    \item \code{\link{expValLimLnorm}}  gives the limited mean.
    \item \code{\link{expValTruncLnorm}}  gives the truncated mean.
    \item \code{\link{stopLossLnorm}}  gives the stop-loss.
    \item \code{\link{meanExcessLnorm}}  gives the mean excess loss.
    \item \code{\link{VatRLnorm}}  gives the Value-at-Risk.
    \item \code{\link{TVatRLnorm}}  gives the Tail Value-at-Risk.
  }
 Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Lognormal distribution with mean \eqn{\mu}{mu} and variance \eqn{\sigma}{sigma}.
}
\details{
The Log-normal distribution with mean \eqn{\mu}{mu} and standard deviation
\eqn{\sigma}{sigma} has density:
  \deqn{\frac{1}{\sqrt{2\pi}\sigma x}\textrm{e}^{-\frac{1}{2}\left(\frac{\ln(x) - \mu}{\sigma}\right)^2}}{f(x) = e^(-(1/2) ((ln(x) - mu)/sigma)^2) / ((2 pi)^(1/2) sigma x}
for \eqn{x \in \mathcal{R}^{+}}{x >= 0}, \eqn{\mu \in \mathcal{R}, \sigma > 0}{mu real, sigma > 0}.
}
\note{
Function VatRLnorm is a wrapper of the \code{\link[stats]{qlnorm}}
function from the stats package.
}
\examples{
expValLnorm(meanlog = 3, sdlog = 5)

varLnorm(meanlog = 3, sdlog = 5)

kthMomentLnorm(k = 2, meanlog = 3, sdlog = 5)

expValLimLnorm(d = 2, meanlog = 2, sdlog = 5)

expValTruncLnorm(d = 2, meanlog = 2, sdlog = 5)

# Values greater than d
expValTruncLnorm(d = 2, meanlog = 2, sdlog = 5, less.than.d = FALSE)

stopLossLnorm(d = 2, meanlog = 2, sdlog = 5)

meanExcessLnorm(d = 2, meanlog = 2, sdlog = 5)

VatRLnorm(kap = 0.8, meanlog = 3, sdlog = 5)

TVatRLnorm(kap = 0.8, meanlog = 2, sdlog = 5)

}
