% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_funs.R
\name{summary.DiscreteFWER}
\alias{summary.DiscreteFWER}
\alias{print.summary.DiscreteFWER}
\title{Summarizing Discrete FWER Results}
\usage{
\method{summary}{DiscreteFWER}(object, ...)

\method{print}{summary.DiscreteFWER}(x, max = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{DiscreteFWER}.}

\item{...}{further arguments passed to or from other methods.}

\item{x}{an object of class \code{summary.DiscreteFWER}.}

\item{max}{numeric or \code{NULL}, specifying the maximal number of
\emph{rows} of the p-value table to be printed. By default,
when \code{NULL}, \code{getOption("max.print")} is used.}
}
\value{
\code{summary.DiscreteFWER} computes and returns a list that includes all the
data of an input \code{DiscreteFWER} object, plus
\item{Table}{\code{data.frame}, sorted by the raw p-values, that contains the
indices, the raw p-values themselves, their respective critical
values (if present), their adjusted p-values (if present) and a
logical column to indicate rejection.}
}
\description{
\code{summary} method for class \code{DiscreteFWER}.
}
\details{
\code{summary.DiscreteFWER} objects contain all data of an \code{DiscreteFWER} object,
but also include an additional table which includes the raw p-values,
their indices, the respective critical values (if present), the adjusted
p-values (if present) and a logical column to indicate rejection. The table
is sorted in ascending order by the raw p-values.

\code{print.summary.DiscreteFWER} simply prints the same output as
\code{print.DiscreteFWER}, but also prints the p-value table.
}
\examples{
X1 <- c(4, 2, 2, 14, 6, 9, 4, 0, 1)
X2 <- c(0, 0, 1, 3, 2, 1, 2, 2, 2)
N1 <- rep(148, 9)
N2 <- rep(132, 9)
Y1 <- N1 - X1
Y2 <- N2 - X2
df <- data.frame(X1, Y1, X2, Y2)
df

# Computation of p-values and their supports with Fisher's exact test
library(DiscreteTests)  # for Fisher's exact test
test_results <- fisher_test_pv(df)
raw_pvalues <- test_results$get_pvalues()
pCDFlist <- test_results$get_pvalue_supports()

# d-Holm procedure without critical values; using test results object
DFWER_dep_sd_fast <- discrete_FWER(test_results)
summary(DFWER_dep_sd_fast)

# d-Bonferroni procedure with critical values; using test results object
DFWER_dep_crit <- discrete_FWER(test_results, single_step = TRUE,
critical_values = TRUE)
summary(DFWER_dep_crit)

}
