% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscreteFWER-package.R
\docType{package}
\name{DiscreteFWER-package}
\alias{DiscreteFWER}
\alias{DiscreteFWER-package}
\title{FWER-Based Multiple Testing Procedures with Adaptation for Discrete Tests}
\description{
This package implements adaptions for discrete tests of the Bonferroni, Holm,
Hochberg and Šidák procedures for control of the family-wise error rate
(FWER).
}
\details{
The main function \code{\link[=discrete_FWER]{discrete_FWER()}} makes all four procedures available to
the user. \code{\link[=DBonferroni]{DBonferroni()}}, \code{\link[=DHolm]{DHolm()}}, \code{\link[=DHochberg]{DHochberg()}} and \code{\link[=DSidak]{DSidak()}}
are wrapper functions that enable the user to access them directly. Their
main parameters are either a
\code{\link[DiscreteTests:DiscreteTestResults]{DiscreteTestResults}} object from
package \link[DiscreteTests:DiscreteTests-package]{DiscreteTests} or a vector of
raw observed p-values and a list whose elements are the discrete supports
of the CDFs of the \eqn{p}-values.

The function \code{\link[=direct_discrete_FWER]{direct_discrete_FWER()}}is a wrapper for
\code{\link[DiscreteFDR:generate.pvalues]{DiscreteFDR::generate.pvalues()}} and \code{\link[=discrete_FWER]{discrete_FWER()}}, which applies
discrete procedures directly to data.
}
\references{
Döhler, S. (2010). Validation of credit default probabilities using
multiple-testing procedures. \emph{Journal of Risk Model Validation}, \emph{4}(4),
59-92. \doi{10.21314/JRMV.2010.062}

Zhu, Y., & Guo, W. (2019). Family-Wise Error Rate Controlling Procedures for
Discrete Data. \emph{Statistics in Biopharmaceutical Research}, \emph{12}(1),
117-128. \doi{10.1080/19466315.2019.1654912}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/DISOhda/DiscreteFWER}
  \item Report bugs at \url{https://github.com/DISOhda/DiscreteFWER/issues}
}

}
\author{
\strong{Maintainer}: Florian Junge \email{diso.fbmn@h-da.de} (\href{https://orcid.org/0009-0001-6856-6938}{ORCID}) [contributor]

Authors:
\itemize{
  \item Sebastian Döhler \email{sebastian.doehler@h-da.de} (\href{https://orcid.org/0000-0002-0321-6355}{ORCID}) [contributor]
}

}
