% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DECORATE.R
\name{DECORATE}
\alias{DECORATE}
\title{Binary classification with DECORATE (Melville and Mooney, 2005)}
\usage{
DECORATE(x, y, C = 15, I = 50, R = 1, verbose = FALSE)
}
\arguments{
\item{x}{a data frame of predictor (numeric, integer or factors). Character
variables should be transformed to factors.}

\item{y}{a vector of response labels. Only \{0, 1\} is allowed.}

\item{C}{the desired ensemble size. Set to 15 as recommended by Melville and
Mooney (2005).}

\item{I}{the maximum number of iterations. Set to 50 as recommended by
Melville and Mooney (2005).}

\item{R}{the amount of articially generated examples, expressed as a fraction
of the number of training examples. R is set to 1, meaning that the number
of artificially created samples is equal to the training set size.}

\item{verbose}{TRUE or FALSE. Should information be printed on the screen?}
}
\value{
an object of class \code{DECORATE}.
}
\description{
\code{DECORATE} (Diverse Ensemble Creation by Oppositional Relabeling of
Artificial Training Examples) builds an ensemble of J48 trees by recursively
adding artificial samples of the training data.
}
\examples{

data(iris)
y <- as.factor(ifelse(iris$Species[1:100]=="setosa",0,1))
x <- iris[1:100,-5]
dec <- DECORATE(x = x, y = y)

}
\references{
Melville, P., & Mooney, R. J. (2005). Creating diversity in ensembles using artificial data. Information Fusion, 6(1), 99-111. <doi: 10.1016/j.inffus.2004.04.001>
}
\seealso{
\code{\link{predict.DECORATE}}
}
\author{
Authors: Matthias Bogaert, Maintainer: \email{Matthias.Bogaert@UGent.Be}
}
