% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_organism_indices}
\alias{get_organism_indices}
\title{Retrieve genes corresponding to the organism of interest}
\usage{
get_organism_indices(count_matrix, organism)
}
\arguments{
\item{count_matrix}{Matrix or dgCMatrix containing the counts from
single cell RNA sequencing data.}

\item{organism}{String specifying the organism of origin of the input
data where there are two standard options,
\itemize{
\item "Hsap"
\item "Mmus"
}

If a user wishes to use a non-standard organism they must input a list
containing strings for the patterns to match mitochondrial and ribosomal
genes of the organism. If available, nuclear-encoded genes that are likely
retained in the nucleus, such as in nuclear speckles, must also
be specified. An example for humans is below,
\itemize{
\item organism = c(mito_pattern = "^MT-",
ribo_pattern = "^(RPS|RPL)",
nuclear <- c("NEAT1","XIST", "MALAT1")
\item Default is "Hsap"
}}
}
\value{
List containing the indices of the count matrix corresponding to
mitochondrial, non-mitochondrial, and ribosomal gene sets.
}
\description{
Retrieve genes corresponding to the organism of interest
}
\keyword{internal}
