% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DTWrapper2.R
\name{dt.round.exactly}
\alias{dt.round.exactly}
\title{dt.round.exactly}
\usage{
dt.round.exactly(
  dt.name,
  the.variables = ".",
  digits = 0,
  the.filter = NULL,
  decimal = ".",
  return.as = "result",
  envir = parent.frame(),
  ...
)
}
\arguments{
\item{dt.name}{a character value specifying the name of a data.frame or data.table object.}

\item{the.variables}{a character vector specifying the variables that we want to apply a function to.  Only values that exist in names(dat) will be used; other values in the.variables will be excluded from the calculation.  When the.variables includes ".", then all values in names(dat) will be selected.  Values of the.variables that also exist in grouping.variables will be excluded from the.variables (but grouped by these values).}

\item{digits}{the number of digits to round to.  This number will be exact, in that there will be exactly k decimal places listed even if this includes lagging zeros.  For instance, setting k = 5 for x = 2.54 would result in 2.54000}

\item{the.filter}{a character value, logical value, or expression stating the logical operations to be performed in filtering the data prior to calculating the.function.}

\item{decimal}{The character specifying the decimal, which splits between whole numbers (greater than 1) and the fractional component (less than 1).}

\item{return.as}{describes whether return should be result, code or mixture of both}

\item{envir}{the environment in which the code would be evaluated; parent.frame() by default.}

\item{...}{additional arguments to be passed}
}
\value{
The function's output depends on the 'return.as' parameter:
- If 'return.as' is "result", it returns a modified version of the input data frame or data table with the specified variables rounded to the exact number of decimal places as defined by 'digits'. The rounding is performed even if this results in trailing zeros, ensuring that each value has precisely the specified number of decimal places.
- If 'return.as' is "code", the function provides the R code or expressions that would perform this precise rounding, allowing users to review or manually execute the code as needed.
- If 'return.as' specifies another option, the output might include both the rounded data and the corresponding R code, depending on the function's implementation.

The function facilitates precise numerical formatting, enhancing data readability and consistency, especially useful in scenarios where a specific decimal precision is required for subsequent analyses or reporting.
}
\description{
rounds the number to exactly desired decimals
}
