% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesp.rel.R
\name{sesp.rel}
\alias{sesp.rel}
\title{Comparison of the accuracy of two tests using relative sensitivity and specificity}
\usage{
sesp.rel(tab, alpha)
}
\arguments{
\item{tab}{an object of class \code{tab.paired}.}

\item{alpha}{significance level alpha used to compute two-sided 100(1-alpha)\%-confidence intervals, the default is 0.05.}
}
\value{
A list containing:
\item{sensitivity}{a named vector containing \code{test1} (the sensitivity for test 1), \code{test2} (the sensitivity for test 2), 
\code{rel.sens} (the relative difference between the two sensitivities, computed as \code{test2/test1}), 
\code{se.log.rel.sens} (the standard error for log(\code{rel.sens})), \code{lcl.rel.sens} (the lower confidence limit for \code{rel.sens}), 
 \code{ucl.rel.sens} (the upper confidence limit for \code{rel.sens}), and \code{pval.rel.sens} (the p-value from the test for
 the null hypothesis: relative sensitivity=1).}
\item{specificity}{a named vector containing \code{test1} (the specificity for test 1), \code{test2} (the specificity for test 2), 
\code{rel.spec} (the relative difference between the two specificities, computed as \code{test2/test1}), 
\code{se.log.rel.spec} (the standard error for log(\code{rel.spec})), \code{lcl.rel.spec} (the lower confidence limit for \code{rel.spec}), 
 \code{ucl.rel.spec} (the upper confidence limit for \code{rel.spec}), and \code{pval.rel.spec} (the p-value from the test for
 the null hypothesis: relative specificity=1).}
\item{alpha}{significance level alpha for 100(1-alpha)\%-confidence intervals for \code{rel.sens} and \code{rel.spec}.}
}
\description{
Calculates two-sided Wald confidence intervals and performs a Wald test for the relative
sensitivity and specificity of two binary diagnostic tests in a paired study design.
}
\details{
If relative sensitivity>1, the percentage increase in sensitivity for \code{test2} relative to \code{test1} is computed as 100(relative sensitivity-1)\%. If 
relative sensitivity<1 the percentage decrease in sensitivity for \code{test2} relative to \code{test1} is computed as 100(1-relative sensitivity)\%. 
Percentage increase/decrease in specificity is computed in an analogous fashion. 

Given the independence of relative sensitivity and relative specificity, a possible joint 100(1-alpha)\% confidence region for \{relative sensitivity, relative specificity\}
is formed by the rectangle \{\code{lcl.rel.sens}, \code{ucl.rel.sens}\} x \{\code{lcl.rel.spec}, \code{ucl.rel.spec}\}, where \{\code{lcl.rel.sens}, \code{ucl.rel.sens}\} and
\{\code{lcl.rel.spec}, \code{ucl.rel.spec}\} are 100(1-alpha*)\% confidence intervals for relative sensitivity and relative specificity, respectively, and alpha*=1-sqrt(1-alpha).

The McNemar's test implemented in \code{sesp.mcnemar} is asymptotically equivalent to the Wald test implemented here.
}
\examples{
data(Paired1) # Hypothetical study data
ftable(Paired1)
paired.layout <- tab.paired(d=d, y1=y1, y2=y2, data=Paired1)
paired.layout 
sesp.rel.results <- sesp.rel(paired.layout)
str(sesp.rel.results)
sesp.rel.results
}
\references{
Alonzo, T. A., Pepe, M. S., & Moskowitz, C. S. (2002). Sample size calculations for comparative studies of medical tests for detecting presence of disease. \emph{Statistics in medicine}, 21(6), 835-852.
}
\seealso{
\code{sesp.diff.ci}, \code{sesp.mcnemar}, and \code{sesp.exactbinom}.
}
