% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datashield.assign.R
\name{datashield.assign.resource}
\alias{datashield.assign.resource}
\title{Resource assignment}
\usage{
datashield.assign.resource(
  conns,
  symbol,
  resource,
  async = TRUE,
  success = NULL,
  error = NULL,
  errors.print = getOption("datashield.errors.print", FALSE)
)
}
\arguments{
\item{conns}{\code{\link{DSConnection-class}} object or a list of \code{\link{DSConnection-class}}s.}

\item{symbol}{Name of the R symbol.}

\item{resource}{Fully qualified name of a resource reference in the data repository (can be a vector or must be
the same in each data repository); or a named list of fully qualified resource names (one per server
name); or a data frame with 'server' and 'resource' columns (such as the one that is used in
\code{\link{datashield.login}})}

\item{async}{Whether the result of the call should be retrieved asynchronously. When TRUE (default) the calls are parallelized over
the connections, when the connection supports that feature, with an extra overhead of requests.}

\item{success}{Callback function that will be called each time an assignment is successful.
The expected function signature is the connection/study name. Default is NULL (no callback).}

\item{error}{Callback function that will be called each time the assignment request has failed.
The expected function signature is the connection/study name and the error message. Default is NULL (no callback).}

\item{errors.print}{Boolean, whether to print datashield errors in the console or return a message indicating that they can be retrieved using `datashield.errors`.}
}
\description{
Assign a resource object of class 'ResourceClient' to a R symbol in the Datashield R session.
}
\examples{
\dontrun{
# assign a resource asynchronously
datashield.assign.resource(conn, symbol="rsrc", resource="RSRC.CNSIM1")

# assign a resource synchronously
datashield.assign.resource(conn, symbol="rsrc", resource="RSRC.CNSIM1", async = FALSE)

# assign the tables that are defined in the logindata ('server' and 'resource' columns are
# expected) data frame that is used in datashield.login() function. Connections names
# and server names must match.
datashield.assign.resource(conns, "rsrc", logindata)

# assign the resources that are defined in the provided named list.
# Connections are filtered by the list names.
datashield.assign.resource(conns, "rsrc",
  list(server1="RSRC.CNSIM1", server2="RSRC.CNSIM2"))

# do assignment with callback functions
datashield.assign.resource(conn, symbol="rsrc",
  resource = list(server1="RSRC.CNSIM1", server2="RSRC.CNSIM2"),
  success = function(server) {
    # do something with server's success
  },
  error = function(server, error) {
    # do something with server's error message
  })
}
}
