% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_basicvirus_ode.R
\name{simulate_basicvirus_ode}
\alias{simulate_basicvirus_ode}
\title{Basic Virus Model}
\usage{
simulate_basicvirus_ode(
  U = 1e+05,
  I = 0,
  V = 1,
  n = 0,
  dU = 0,
  dI = 1,
  dV = 2,
  b = 2e-05,
  p = 5,
  g = 1,
  tstart = 0,
  tfinal = 30,
  dt = 0.1
)
}
\arguments{
\item{U}{: starting value for Uninfected cells : numeric}

\item{I}{: starting value for Infected cells : numeric}

\item{V}{: starting value for Virus : numeric}

\item{n}{: rate of new uninfected cell replenishment : numeric}

\item{dU}{: rate at which uninfected cells die : numeric}

\item{dI}{: rate at which infected cells die : numeric}

\item{dV}{: rate at which virus is cleared : numeric}

\item{b}{: rate at which virus infects cells : numeric}

\item{p}{: rate at which infected cells produce virus : numeric}

\item{g}{: possible conversion factor for virus units : numeric}

\item{tstart}{: Start time of simulation : numeric}

\item{tfinal}{: Final time of simulation : numeric}

\item{dt}{: Time step : numeric}
}
\value{
The function returns the output as a list.
The time-series from the simulation is returned as a dataframe saved as list element \code{ts}.
The \code{ts} dataframe has one column per compartment/variable. The first column is time.
}
\description{
A basic virus infection model with 3 compartments
}
\details{
The model includes uninfected and infected target cells, as well as free virus. The processes that are modeled are infection, virus production, uninfected cell birth and death, infected cell and virus death.

This code was generated by the modelbuilder R package.
The model is implemented as a set of ordinary differential equations using the deSolve package.
The following R packages need to be loaded for the function to work: deSolve.
}
\section{Warning}{
 This function does not perform any error checking. So if you try to do something nonsensical (e.g. have negative values for parameters), the code will likely abort with an error message.
}

\section{Model Author}{
 Andreas Handel
}

\section{Model creation date}{
 2021-07-19
}

\section{Code Author}{
 generated by the \code{modelbuilder} R package
}

\section{Code creation date}{
 2021-07-19
}

\examples{
# To run the simulation with default parameters:
result <- simulate_basicvirus_ode()
# To choose values other than the standard one, specify them like this:
result <- simulate_basicvirus_ode(U = 2e+05,I = 0,V = 2)
# You can display or further process the result, like this:
plot(result$ts[,'time'],result$ts[,'U'],xlab='Time',ylab='Numbers',type='l')
print(paste('Max number of U: ',max(result$ts[,'U'])))
}
