% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiftedMMD.R
\name{shiftedMMD}
\alias{shiftedMMD}
\title{A function computing an estimate of the shifted-MMD.}
\usage{
shiftedMMD(X, Y, r, kernel)
}
\arguments{
\item{X}{A numeric vector containing the first sample.}

\item{Y}{A numeric vector containing the second sample.}

\item{r}{A function specifying the hypothesised density ratio.}

\item{kernel}{A function defining the kernel to be used for the U-statistic.}
}
\value{
The value of the U-statistic (12).
}
\description{
A function computing the U-statistic (12). This serves as an estimator
of the shifted-MMD defined in Section 3.2 of \insertCite{BB2025DRPT;textual}{DRPT}.
}
\examples{
n = 250; m = 250; d = 2
r = function(x,y) {
  return(4*x*y)
   }

gaussian.kernel = function(x, y, lambda = 1){
     return(lambda^(-d) * exp(-sum(((x - y) ^ 2) / (lambda ^ 2))))
     }

X = as.matrix(cbind(runif(n, 0, 1), runif(n, 0, 1)))
Y = as.matrix(cbind(rbeta(m, 0.5, 0.3), rbeta(m, 0.5, 0.4)))

shiftedMMD(X,Y, r, gaussian.kernel)
}
\references{
\insertRef{BB2025DRPT}{DRPT}
}
