% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete.DRPT.R
\name{discrete.DRPT}
\alias{discrete.DRPT}
\title{A function implementing the discrete version of the DRPT for discrete data with finite support.}
\usage{
discrete.DRPT(X, Y, r, H = 99, type = "V")
}
\arguments{
\item{X}{A numeric vector containing the first sample.}

\item{Y}{A numeric vector containing the second sample.}

\item{r}{A numeric vector of positive values specifying the hypothesised density ratio in the discrete setting.}

\item{H}{An integer specifying the number of permutations to use. Defaults to 99.}

\item{type}{A character string indicating the test statistic to use. See the Details section for more information.
Defaults to \code{"V"}.}
}
\value{
The p-value of the DRPT as defined in (2) in \insertCite{BB2025DRPT;textual}{DRPT}.
}
\description{
A function that implements the discrete version of the DRPT for discrete data with finite support
as defined in Section 2.1 in \insertCite{BB2025DRPT;textual}{DRPT}.
}
\details{
Counts for the permuted samples are drawn using \code{rMFNCHypergeo} from the package \code{BiasedUrn}.
When \code{type="U"} the test statistic is the U-statistic (12); when \code{type="V"} the test statistic is the V-statistic (11); setting \code{type="D"}
gives the test statistic (56) in Appendix B of the paper.
}
\examples{
n = 100; m = n
X = sample(0:3, n, prob = c(1/8, 1/8, 3/8, 3/8), replace = TRUE)
Y = sample(0:3, m, prob = c(1/43, 3/43, 16/43, 23/43), replace = TRUE)
r = c(1, 3, 3, 10)

discrete.DRPT(X,Y,r,H=19)
discrete.DRPT(X,Y,r, type = "U", H=19)
discrete.DRPT(X,Y,r, type = "D", H=19)
}
\references{
\insertRef{BB2025DRPT}{DRPT}
}
