% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataAccess.R
\name{pooledVarDataAccess}
\alias{pooledVarDataAccess}
\title{Differentially Private Pooled Variance Data Access Function}
\usage{
pooledVarDataAccess(samples, lower.bound, upper.bound, approx.n.max)
}
\arguments{
\item{samples}{List of vectors from which to compute the pooled variance.}

\item{lower.bound}{Real number giving the lower bound of the input data.}

\item{upper.bound}{Real number giving the upper bound of the input data.}

\item{approx.n.max}{Logical indicating whether to approximate n.max, which is
defined to be the length of the largest input vector. Approximation is best
if n.max is very large.}
}
\value{
List of the true pooled variance and the sensitivities calculated
based on bounded and unbounded differential privacy.
}
\description{
This function performs the data access step in the computation of a
differentially private pooled variance. The true values are computed using
the theoretical formula and \code{\link[stats]{var}}, while the sensitivities
are calculated based on bounded and unbounded differential privacy
\insertCite{Kifer2011}{DPpack} according to the theoretical values
\insertCite{Liu2019b}{DPpack}.
}
\examples{
pooledVarDataAccess(list(c(1,4,-2,8,-6),c(1,2),c(-5,-7)),-10,10,FALSE)

}
\references{
\insertRef{Liu2019b}{DPpack}

\insertRef{Kifer2011}{DPpack}
}
\keyword{internal}
