% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compress_lookup.R
\name{compress_lookup}
\alias{compress_lookup}
\title{Collapse Redundant Rows of a Lookup Table}
\usage{
compress_lookup(
  lookupTable,
  compressOriginalWord = FALSE,
  compressClass = FALSE,
  compressCategory = FALSE,
  compressSynonym = TRUE
)
}
\arguments{
\item{lookupTable}{A lookup table with category \code{data.frame} having three
columns: drug class, drug category, and drug street name. These tables are
returned by the function \code{\link{lookup}}.}

\item{compressOriginalWord}{Should the search word(s) be collapsed? Defaults to
\code{FALSE}.}

\item{compressClass}{Should the drug class be collapsed? Defaults to
\code{FALSE}.}

\item{compressCategory}{Should the drug category be collapsed? Defaults to
\code{FALSE}.}

\item{compressSynonym}{Should the drug synonym / street name be collapsed?
Defaults to \code{TRUE}.}
}
\value{
A compressed lookup table, with unwanted columns removed.
}
\description{
Given a Drug Lookup table as returned by the function
\code{\link{lookup}}, collapse rows from unwanted columns
}
\examples{
  longExampleTable <- lookup("dope", "methamphetamine")
  compress_lookup(longExampleTable)
  compress_lookup(longExampleTable, compressCategory = TRUE)
}
