% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_simulation.R
\name{data_simulation}
\alias{data_simulation}
\title{Simulate data for the DNN-SIM model}
\usage{
data_simulation(n, beta, w, sigma, delta, seed)
}
\arguments{
\item{n}{an integer. The sample size.}

\item{beta}{a vector. The covariate coefficients.}

\item{w}{a number between 0 and 1. The skewness parameter.}

\item{sigma}{a number larger than 0. The standard deviation parameter.}

\item{delta}{a number larger than 0. The degree of freedom parameter.}

\item{seed}{an integer. The random seed.}
}
\value{
a dataframe of the simulated response variable y and the design matrix X.
}
\description{
Simulate data for the DNN-SIM model
}
\details{
This is a simple data generation function for a simulation study. All elements of the design matrix X follow a uniform distribution from -3.0 and 3.0 independently and identically. The true \eqn{g} function is the standard logistic function.
}
\examples{

\donttest{
# check python module dependencies
if (reticulate::py_module_available("torch") &
    reticulate::py_module_available("numpy") &
    reticulate::py_module_available("sklearn") &
    reticulate::py_module_available("scipy")) {
  df1 <- data_simulation(n=50,beta=c(1,1,1),w=0.3,
                         sigma=0.1,delta=4.0,seed=100)
  print(head(df1))
}
}

}
\references{
\insertRef{liu2022bayesian}{DNNSIM}
}
