% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ContigencyTables.r
\name{ContigencyTables}
\alias{ContigencyTables}
\title{Function to create contigency tables}
\usage{
ContigencyTables (Response.data, Response.code=c(0,1), 
       Group, group.names=NULL, Stratum=NULL, Cluster=NULL, 
       missing.code="NA", missing.impute="LW", print.information=TRUE)
}
\arguments{
\item{Response.data}{A scored item responses matrix in the form of matrix or data frame. This matrix should not include any
other variables (group, stratum, cluser, etc.).}

\item{Response.code}{A numerical vector of all possible item responses. By default, Response.code=c(0,1).}

\item{Group}{The variable of group membership (e.g., gender). Its length should be equal to the sample size of the item response matrix.}

\item{group.names}{Names for each defined group (e.g., c('Male','Female')). This argument is optional. By default, group.names=NULL.
If not provided, group names of "Group.1, Group.2, etc." will be automatically generated.}

\item{Stratum}{The matching variable. By default, Stratum=NULL. If not provided, the observed total score will be used.}

\item{Cluster}{The cluster variable. Its length should be equal to the sample size of the item response matrix. By default, Cluster=NULL.
This variable will not be used to generate contigency tables. It will be included in the returned data set for DIF analysis.}

\item{missing.code}{Indication of how missing values were defined in the data. By default, missing.code="NA".}

\item{missing.impute}{The approach selected to handle missing item responses. By default, missing.impute="LW", indicating the list-wise
deletion will be used. Other options include: "PM" (person mean or row mean imputation),"IM" (item mean or column mean imputation), 
"TW" (two-way imputation), "LR" (logistic regression imputation), and EM (EM imputation). Check the package "TestDataImputation" 
(\url{https://cran.r-project.org/package=TestDataImputation}) for more details. \cr
Note. If any missing data are detected on group, cluster, or stratum variables, listwise deletion will be used before handling missing item responses.}

\item{print.information}{Indicator of whether function running information is printed on screen. By default, print.information=TRUE.}
}
\value{
A list of strata statistcs, contigency tables, etc. 
\item{Strata.stats}{Summary statistics for each item: n.valid.strata, n.valid.category, and also sample sizes for each stratum across items.}
\item{c.table.list.all}{A list that contains all contigency tables across items and strata.}
\item{c.table.list.valid}{A list that contains only valid contigency tables across items and strata. 
Strata that have missing item response categories or zero marginal means are removed.}
\item{data.out}{A cleaned data set with variables "Group",  "Group.factor","Cluster", "Stratum", 
and all item responses (with missing data handled).}
}
\description{
This function creates contigency tables by strata for each item. Both dichotomous and polytomous item responses are allowed.
It also handles missing responses and returns a cleaned data set with no missing data.
}
\details{
This function creats contigency tables.
}
\examples{
#Specify the item responses matrix
data(data.adult)
Response.data<-data.adult[,2:13]
#Run the function with specifications      
c.table.out<-ContigencyTables(Response.data, Response.code=c(0,1), 
                              Group=data.adult$Group, group.names=NULL, 
                              Stratum=NULL, Cluster=NULL, missing.code="NA", 
                              missing.impute= "LW",print.information = TRUE)
#Obtain results
c.tables.all<-c.table.out$c.table.list.all
c.tables.valid<-c.table.out$c.table.list.valid
c.table.out$Strata.stats
data.use<-c.table.out$data.out
}
