test_that("single_lmre2 runs mixed-effects regression correctly", {
  # Create dummy data
  set.seed(123)
  dummy_data <- data.frame(
    years_education = rnorm(100, 12, 3),
    gender_female = rbinom(100, 1, 0.5),
    household_wealth = sample(1:5, 100, replace = TRUE),
    district_code = sample(1:10, 100, replace = TRUE),
    HHid = as.character(rep(1:20, each = 5, length.out = 100))
  )

  # Define formula
  formula <- years_education ~ gender_female + household_wealth:gender_female

  # Run the mixed-effects model for a specific district (suppress warnings)
  result <- suppressWarnings(single_lmre2(dummy_data, formula, "district_code", "HHid", location_index = 1))

  # Test if the result contains the expected columns
  expect_true("estimate" %in% colnames(result))
  expect_true("std_error" %in% colnames(result))

  # Test if the result has the correct number of rows for coefficients and R-squared
  expect_true(any(result$term == "Marginal R-squared"))
  expect_true(any(result$term == "Conditional R-squared"))
})
