test_that("Spdeplisa calculates Local Moran's I and sign combinations correctly", {
  # Create dummy data
  set.seed(123)
  dummy_data <- data.frame(
    district_code = sample(1:10, 100, replace = TRUE),
    household_wealth = sample(1:5, 100, replace = TRUE)
  )

  # Generate 100 random points for the geometry column
  dummy_data$geometry <- sf::st_sfc(lapply(1:100, function(x) sf::st_point(runif(2))))

  # Create a spatial weights object (listw)
  coords <- matrix(runif(200), ncol = 2)
  distances <- as.matrix(dist(coords))
  weights <- exp(-distances / 0.2)
  diag(weights) <- 0
  listw <- spdep::mat2listw(weights, style = "W")

  # Run Spdeplisa to calculate Local Moran's I and sign combinations
  result <- Spdeplisa(dummy_data, "household_wealth", listw)

  # Test if the result contains the expected columns
  expect_true("lisa_I" %in% colnames(result))
  expect_true("lisa_p" %in% colnames(result))
  expect_true("sign_combination2" %in% colnames(result))
  expect_true("sign_combination3" %in% colnames(result))

  # Test if the output for Local Moran's I (lisa_I) is not NA
  expect_false(any(is.na(result$lisa_I)))
})
