% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{single_glmre2}
\alias{single_glmre2}
\title{Mixed-Effects Logistic Regression Analysis for a Specified Location}
\usage{
single_glmre2(
  data,
  formula,
  location_var,
  random_effect_var,
  location_index,
  family = NULL
)
}
\arguments{
\item{data}{The dataset to be analyzed.}

\item{formula}{The formula for the regression model.}

\item{location_var}{The variable indicating different locations (e.g., `REGCODE`).}

\item{random_effect_var}{The variable to be used as a random effect (e.g., `hhid`).}

\item{location_index}{The specific location index or number for which the model should be run.}

\item{family}{The family to be used for GLM (e.g., `binomial` for logistic regression).}
}
\value{
The results for sigle location to test
}
\description{
This function runs a mixed-effects logistic regression model for a specified location within a dataset.
}
\examples{
set.seed(123)
  library(dplyr)
# Create dummy data
dummy_data <- data.frame(
  years_education = rnorm(100, 12, 3),    # Represents years of education
  gender_female = rbinom(100, 1, 0.5),    # 1 = Female, 0 = Male
  household_wealth = sample(1:5, 100, replace = TRUE),  # Wealth index from 1 to 5
  district_code = sample(1:10, 100, replace = TRUE)     # Represents district codes
) \%>\% arrange(district_code)

# Create HHid (Household ID), grouping every 3-4 records, and convert to character
dummy_data$HHid <- as.character(rep(1:20, each = 5, length.out = nrow(dummy_data)))

# Create a binary outcome variable for years of education
dummy_data$education_binary <- ifelse(dummy_data$years_education > 11, 1, 0)

# Define a logistic regression formula
formula <- education_binary ~ gender_female + household_wealth:gender_female

# Set the location and random effect variables
location_var <- "district_code"
random_effect_var <- "HHid"

# Run the mixed-effects logistic regression for a specific location (e.g., district 1)
result_single_glmre <- single_glmre2(dummy_data, formula, location_var, random_effect_var,
 location_index = 1, family = binomial())

# View the result
print(result_single_glmre)
}
