% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_and_preprocess_data.R
\name{read_and_preprocess_data}
\alias{read_and_preprocess_data}
\title{Function to read data and perform initial pre-processing}
\usage{
read_and_preprocess_data(
  datafile,
  con1,
  con2,
  exp1,
  exp2,
  alpha = 0.05,
  votting_cutoff = 2
)
}
\arguments{
\item{datafile}{A matrix or data frame containing gene expression data}

\item{con1}{Starting column of the control of the expression data}

\item{con2}{Ending column of the control of the expression data}

\item{exp1}{Starting column of the experiment of the expression data}

\item{exp2}{Ending column of the experiment of the expression data}

\item{alpha}{Value of significance level ranging from 0 to 1 (0.05 states 5 \% significance)(Default = 0.05).}

\item{votting_cutoff}{A numeric value serves as Majority voting (Default = 2)}
}
\value{
A large list containing the data file and the input values
}
\description{
Function to read data and perform initial pre-processing
}
\examples{
data("gene_exp_data")
read_and_preprocess_data(datafile = gene_exp_data, con1=1,con2=10,exp1=11,exp2=20)
}
