% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiValues.R
\name{set_to_distr}
\alias{set_to_distr}
\title{set_to_distr}
\usage{
set_to_distr(set, length = 0)
}
\arguments{
\item{set}{Normally a numeric vector containing integer numbers.}

\item{length}{The required length of the resulting distribution vector. The actual length
is determined as \code{max(length, max(set))}, so the \code{length} is extended when too small
to hold the whole distribution.}
}
\value{
A \link{distribution} object of length \code{length}. Arguments that
are already distributions are returned "as is". Input vectors of length 0 and other types
of objects return \code{NA}.
}
\description{
Convert a DEXi value set to DEXi value distribution.
}
\examples{
set_to_distr(c(1, 3, 4))
set_to_distr(c(1, 3, 4), length = 5)
set_to_distr(c(1, 3, 4), length = 0)

}
\seealso{
\link{DEXiR-package}, \link{distribution}, \code{\link[=distr_to_set]{distr_to_set()}}
}
