% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiValues.R
\name{dexi_value}
\alias{dexi_value}
\title{dexi_value}
\usage{
dexi_value(x, add = 0)
}
\arguments{
\item{x}{character(1).}

\item{add}{A numeric constant to be added to the result. Useful
when converting DEXi's zero-based representation to one-based representation used in R,
which requires the setting \code{add = 1}.}
}
\value{
A single integer or real number, an integer numeric vector, or a \link{distribution}.
}
\description{
Conversion of a string to a "DEXi value" (see \link{DEXiR-package}) according to "new"
DEXi syntax rules. In \code{.dxi} files, this syntax is used in \code{ALTERNATIVE} and
\code{RULE} XML tags. Examples of possible options include:
\preformatted{
 x                              result
 ------------------------------+-------------------------------------------------
 NULL or ""                     NULL
 "*"                            "*"
 a string starting with "undef" NA
 "2"                            a single ordinal value, c(2) in this case
 "2.1"                          a single number, c(2.1) in this case
 "1:3"                          interval, equivalent to c(1, 2, 3)
 "{0;2;3}"                      a value set, equivalent to c(0, 2, 3)
 "<0;0.3;0.7>"                  a value distribution, distribution(0.0, 0.3, 0.7)
}
}
\examples{
dexi_value("")
dexi_value(NULL)
dexi_value("*")
dexi_value("UNDEF")
dexi_value("2")
dexi_value("2.1")
dexi_value("1:3")
dexi_value("{0;2;3}")
dexi_value("{0;2;3}", add = 1)
dexi_value("<0;0.3;0.7>")

}
\seealso{
\link{DEXiR-package}, \code{\link[=dexi_option_value]{dexi_option_value()}}, \link{distribution}
}
