% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiFunctions.R
\name{dexi_table}
\alias{dexi_table}
\title{dexi_table}
\usage{
dexi_table(dim, low, high = NULL)
}
\arguments{
\item{dim}{An integer vector, representing dimensions of the underlying decision space.}

\item{low}{\code{character(1)}. A string normally read from a \code{.dxi} file, representing the lower bounds
of the corresponding decision rule values (assuming the order according to \code{\link[=dexi_index]{dexi_index()}}).
Notice that the string contains zero-based characters, which are converted to one-based integer values used in R.}

\item{high}{\code{character(1)} or \code{NULL}. A string representing the upper bounds
of corresponding decision rule values. If \code{high = NULL}, \code{high} is assumed
to be equal to \code{low}.}
}
\value{
\code{length(dim)}-dimensional matrix of rule values, which are normally single integer values,
but might also be sets of values. Each set is represented by a numeric vector.
}
\description{
Create a representation of DEXi's decision table in R.
}
\examples{
# Converting DEXi's value strings to R's numeric vectors.
dexi_table(c(2, 3), "011012")
dexi_table(c(2, 3), "011012", "012112")

}
