% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiFunctions.R
\docType{class}
\name{DexiFunction-class}
\alias{DexiFunction-class}
\alias{DexiFunction}
\title{DexiFunction}
\description{
\code{DexiFunction} is a base RC class for representing DEXi aggregation and discretization functions in R.
}
\details{
DEXi functions are generally associated with aggregate attributes. For some aggregate attribute \code{att},
\code{att$funct} defines the mapping from values of \code{att$inputs} to values of \code{att}.

\link{DexiFunction} is a base class that defines fields and methods common to all functions:
\itemize{
\item method \code{value(x)}: returns the function value for arguments \code{x}. Arguments are
assumed to be a numeric vector of length equal to \code{att$inputs}.
\item method \code{evaluate(x)} is a silent wrapper around \code{value(x)}; it returns \code{NULL} when
\code{value(x)} fails with an error.
}

DEXiR implements two other function classes derived from \code{DexiFunction}:
\link{DexiTabularFunction} and \link{DexiDiscretizeFunction}.
}
\section{Methods}{

\describe{
\item{\code{evaluate(x)}}{A silent wrapper around \code{value(x)}; it returns \code{NULL} when
\code{value(x)} fails with an error.}

\item{\code{value(x)}}{Return the function value for arguments \code{x}, where arguments are
a numeric vector of length equal to \code{att$inputs}.
Additionally, arguments of a \code{DexiTabularFunctions$value()} must be integer numbers,
and the argument of \code{DexiDiscretizeFunctions$value()} must be a single number.}

\item{\code{verify()}}{Check the correctnes of this function object and its fields.
Result: \code{error()} or \code{TRUE}.}
}}

