% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiScales.R
\docType{class}
\name{DexiContinuousScale-class}
\alias{DexiContinuousScale-class}
\alias{DexiContinuousScale}
\title{DexiContinuousScale}
\description{
\code{DexiContinuousScale} is a RC class, derived from \code{DexiScale},
representing continuous value scales in R.
}
\details{
An attribute associated with a continuous scale can take any single numeric value from
\verb{[-Inf, +Inf]}.

\code{DexiContinuousScale} defines two numeric bounds, called \code{low_point} and
\code{high_point}, such that \code{low_point <= high_point}. These values partition
preferentially ordered scales in three preferential classes ("qualities"):
\code{"bad"}, \code{"none"} (in the sense of \code{"neutral"}), and \code{"good"}.
For a scale with \code{order = "ascending"}, the three corresponding intervals are
\verb{[-Inf, low_point]}, \verb{(low_point, high_point)} and \verb{[high_point, +Inf]}.
For \code{order = "descending"}, the order of qualities is reversed.
Scales with \code{order = "none"} have only one associated quality,
\code{"none"}, for the whole range of values.

Continuous scales are supported in DEXi Suite software (DEXiWin),
but not in older DEXi Classic software (DEXi).
}
\section{Fields}{

\describe{
\item{\code{low_point}}{numeric. A bound for the quality interval \verb{[-Inf, low_point]}.}

\item{\code{high_point}}{numeric. A bound for the quality interval \verb{[high_point, +Inf]}.}
}}

\section{Methods}{

\describe{
\item{\code{count()}}{Return the number of scale elements.
Equal to \code{NA} for \code{DexiScale}, \code{0} for \code{DexiContinuousScale}, and
equal to \code{nvals >= 0} for \code{DexiDiscreteScale}.}

\item{\code{equal(scl)}}{Check if this scale is equal to scale \code{scl}. Needed for attribute linking.}

\item{\code{initialize(order = EnumOrder, ...)}}{Initialize a \code{DexiScale} object.}

\item{\code{to_string()}}{Return a string representation of this scale for printing.}

\item{\code{value_quality(value)}}{Return the quality (preferential class) of \code{value} on this scale:
one of the strings \code{"bad"}, \code{"none"} or \code{"good"}.
Always \code{"none"} for \code{DexiScale} and scales with \code{order = "none"}.}

\item{\code{verify()}}{Check the correctnes of this scale object and its fields.
Result: \code{error()} or \code{TRUE}.}
}}

