% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyt_bp2.R
\name{cyt_bp2}
\alias{cyt_bp2}
\title{Boxplot Function Enhanced for Specific Group Comparisons. \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
\usage{
cyt_bp2(data, pdf_title, scale = NULL, y_lim = NULL)
}
\arguments{
\item{data}{A matrix or data frame of raw data.}

\item{pdf_title}{A string representing the title
(and filename) of the PDF file. If \code{NULL}, the boxplots are displayed on the
current graphics device. Defaults to \code{NULL}.}

\item{scale}{Transformation option for continuous variables.
Options are NULL (default) and "log2". When set to "log2",
numeric columns are transformed using the log2 function.}

\item{y_lim}{An optional numeric vector defining the y-axis limits
for the plots.}
}
\value{
A PDF file containing the boxplots.
}
\description{
This function generates a PDF file containing boxplots for each combination
of numeric and factor variables in the provided data. It first converts
any character columns to factors and checks that the data contains at
least one numeric and one factor column. If the scale argument is set to
"log2", all numeric columns are log2-transformed. The function then
creates boxplots using ggplot2 for each numeric variable grouped by
each factor variable.
}
\examples{
# Loading data
data_df <- ExampleData1[, -c(3, 5:28)]
data_df <- dplyr::filter(data_df, Group == "T2D", Treatment == "Unstimulated")
cyt_bp2(data_df, pdf_title = NULL, scale = "log2")

}
\author{
Shubh Saraswat
}
