% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyt_bp.R
\name{cyt_bp}
\alias{cyt_bp}
\title{Boxplots for Continuous Variables with Optional Grouping}
\usage{
cyt_bp(
  data,
  output_file = NULL,
  group_by = NULL,
  bin_size = 25,
  y_lim = NULL,
  scale = c("none", "log2", "log10", "zscore", "custom"),
  custom_fn = NULL
)
}
\arguments{
\item{data}{A matrix or data frame containing numeric and
categorical variables.}

\item{output_file}{Optional string specifying the name of the file
to be created.  When \code{NULL} (default), plots are drawn on
the current graphics device. Ensure that the file
extension matches the desired format (e.g., ".pdf" for PDF output
or ".png" for PNG output or .tiff for TIFF output).}

\item{group_by}{Optional character vector specifying one or more
columns to use for grouping.  If \code{NULL} (default) no grouping is
applied.}

\item{bin_size}{Integer.  Maximum number of boxplots per page when
grouping is not used.  Default is 25, as in the original
\code{cyt_bp}.}

\item{y_lim}{Optional numeric vector giving y‑axis limits for the
plots.  Applies to all plots.}

\item{scale}{Character specifying a transformation for numeric
variables.  Accepts \code{"none"}, \code{"log2"}, \code{"log10"},
\code{"zscore"}, or \code{"custom"}.  When \code{"custom"}, supply a
function via \code{custom_fn}.}

\item{custom_fn}{A user supplied function to transform numeric
columns when \code{scale = "custom"}.}
}
\value{
Invisibly returns a list of \code{ggplot} objects.  When
\code{output_file} is provided, plots are written to the PDF file.
}
\description{
This function generates boxplots for numeric variables in a data
frame or matrix.  It supports optional grouping by one or more
categorical variables.  Numeric variables can be scaled using
various transformations before plotting.  When grouping is not
used, boxplots are arranged in pages with a specified maximum
number of plots per page.  Plots can be saved to a PDF file or
displayed on the current graphics device.
}
\examples{
data("ExampleData1")
# Boxplots without grouping
cyt_bp(ExampleData1[, -c(1:3)], output_file = NULL, scale = "log2")
# Boxplots grouped by Group
cyt_bp(ExampleData1[, -c(3,5:28)], group_by = "Group", scale = "zscore")

}
