% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{apply_scale}
\alias{apply_scale}
\title{Apply a scale transformation to numeric columns}
\usage{
apply_scale(
  data,
  columns = NULL,
  scale = c("none", "log2", "log10", "zscore", "custom"),
  custom_fn = NULL
)
}
\arguments{
\item{data}{A data.frame or matrix containing the data to be
transformed.}

\item{columns}{A character vector of column names to transform.  If
NULL (default) all numeric columns will be transformed.}

\item{scale}{A character string specifying the transformation to
apply.  Possible values are "none", "log2", "log10",
"zscore", or "custom".  When set to "custom" the function
specified in \code{custom_fn} will be applied to the columns.}

\item{custom_fn}{A function that takes a numeric vector and returns a
transformed numeric vector.  Only used when \code{scale = "custom"}.}
}
\value{
A data.frame with the same dimensions as \code{data} with
transformed numeric columns.
}
\description{
This helper function applies a chosen scaling or transformation to
specified numeric columns in a data frame.  Supported built‑in
transformations include no transformation ("none"), log2, log10,
and z‑score scaling.  A custom function can also be supplied to
perform arbitrary transformations.
}
