% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cure.R
\name{plot_cure}
\alias{plot_cure}
\title{Plot the survival function}
\usage{
plot_cure(object, scenario = c("t", "c", "both"))
}
\arguments{
\item{object}{an object of the class "dcensoring".}

\item{scenario}{which defines the scenario in the graph (t: failure times, c: dependent censoring times, or both).}
}
\value{
a survival function graph of the fitted model.
}
\description{
This graph helps to visualize the survival function.
}
\details{
In order to smooth the line presented in the graph, we used the 'lowess' function. So, it can result in a non-monotonous survival function.
}
\examples{
\donttest{
library(CureDepCens)

delta_t = ifelse(Dogs_MimicData$cens==1,1,0)
delta_c = ifelse(Dogs_MimicData$cens==2,1,0)

fit <- cure_dep_censoring(formula = time ~ x1_cure + x2_cure | x_c1 + x_c2,
                          data = Dogs_MimicData,
                          delta_t = delta_t,
                          delta_c = delta_c,
                          ident = Dogs_MimicData$ident,
                          dist = "mep")

plot_cure(fit, scenario = "t")
}

}
