% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoxBcv.mdmr.R
\name{CoxBcv.mdmr}
\alias{CoxBcv.mdmr}
\title{Hybrid MDMR bias-corrected sandwich variance estimator}
\usage{
CoxBcv.mdmr(Y, Delta, X, ID)
}
\arguments{
\item{Y}{vector of observed time-to-event data.}

\item{Delta}{vector of censoring indicators.}

\item{X}{matrix of marginal mean covariates with one column for one covariate (design matrix excluding intercept).}

\item{ID}{vector of cluster identifiers.}
}
\value{
\itemize{
  \item coef - estimate of coefficients.
  \item exp(coef) - estimate of hazard ratio.
  \item MDMR-var - MDMR bias-corrected sandwich variance estimate of coef.
}
}
\description{
Calculate the hybrid MDMR bias-corrected sandwich variance estimator, for marginal Cox analysis of cluster randomized trials, 
proposed by Wang et al. (under review). MD: Mancl and DeRouen (2001); MR: martingale residual.
}
\examples{
Y <- c(11,19,43,100,7,100,100,62,52,1,7,6)
Delta <- c(1,1,1,0,1,0,0,1,1,1,1,1)
X1 <- c(0,0,0,0,0,0,1,1,1,1,1,1)
X2 <- c(-19,6,-25,48,10,-25,15,22,17,-9,45,12)
ID <- c(1,1,2,2,3,3,4,4,5,5,6,6)

X <- X1
CoxBcv.mdmr(Y,Delta,X,ID)

X <- cbind(X1,X2)
CoxBcv.mdmr(Y,Delta,X,ID)

}
\references{
Mancl, L. A., & DeRouen, T. A. (2001). 
A covariance estimator for GEE with improved small‐sample properties. 
Biometrics, 57(1), 126-134.

Wang, X., Turner, E. L., & Li, F. 
Improving sandwich variance estimation for marginal Cox analysis of cluster randomized trials. 
Under Review.
}
