% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LastfiveNrMutation.R
\name{LastfiveNrMutation}
\alias{LastfiveNrMutation}
\title{Bacth assay analysis for last five Nr of primers}
\usage{
LastfiveNrMutation(
  nucmerr = nucmerr,
  assays = assays,
  totalsample = totalsample,
  figurelist = FALSE,
  outdir = NULL
)
}
\arguments{
\item{nucmerr}{Mutation information containing group list(derived from "nucmer" object using "nucmerRMD" function).}

\item{assays}{Assays dataframe including the detection ranges of mutations.}

\item{totalsample}{Total sample number, total cleared GISAID fasta data.}

\item{figurelist}{Whether to output the integrated plot list for each assay.}

\item{outdir}{The output directory. if the figurelist = TRUE, output the figure in the R session.}
}
\value{
Plot the mutation counts(last five nucleotides for each primer) for each assay as output.
}
\description{
Last five nucleotides of primer mutation count/type for any reverse transcription
polymerase chain reaction (RT-PCR) primer.
}
\examples{
data("nucmerr")
data("assays")
totalsample <- 434
#outdir <- tempdir()
LastfiveNrMutation(nucmerr = nucmerr,
                   assays = assays,
                   totalsample = totalsample,
                   figurelist = FALSE,
                   outdir = NULL)
}
