% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/B_splines_est.R
\name{splines_df}
\alias{splines_df}
\title{Construct Data Frame of Basis Functions.}
\usage{
splines_df(x, p, m, taus)
}
\arguments{
\item{x}{A vector of lags.}

\item{p}{The order of the splines.}

\item{m}{The number of nonboundary knots.}

\item{taus}{Vector of \eqn{\tau}s, see \link{get_tau}.}
}
\value{
A data frame of the above structure.
}
\description{
This helper function constructs a data frame with the following structure:
\itemize{
\item One column for the x-values
\item m + p columns values of squared basis functions evaluated at the corresponding x.
}
}
\examples{
taus <- get_taus(3, 2)
splines_df(seq(0, 2, by=0.25), 3, 2, taus)
}
