% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{hilbert_schmidt}
\alias{hilbert_schmidt}
\title{Hilbert-Schmidt Norm Between Estimated Autocovariance Functions.}
\usage{
hilbert_schmidt(est1, est2)
}
\arguments{
\item{est1}{A numeric vector representing the first estimated autocovariance function.}

\item{est2}{A numeric vector of the same length as \code{est1} representing the second estimated autocovariance function}
}
\value{
A numeric value representing the estimated Hilbert-Schmidt norm between two estimated autocovariance functions.
}
\description{
This function computes the Hilbert-Schidmt norm between two estimated autocovariance functions.
}
\details{
This function computes the Hilbert-Schidmt norm between two estimated autocovariance functions.
The Hilbert-Schmidt norm of a matrix
\deqn{D = \left[(d_{i,j})_{1 \le i,j \le n}\right] = \left[ {\begin{array}{ccccc}
D(h_{0})     & D(h_{1})     & \cdots & D(h_{n - 1}) & D(h_{n})     \\
D(h_{1})     & D(h_{0})     & \cdots & D(h_{n - 2}) & D(h_{n - 1}) \\
\vdots       & \vdots       & \ddots & \vdots       & \vdots       \\
D(h_{n - 1}) & D(h_{n - 2}) & \cdots & D(h_{0})     & D(h_{1})     \\
D(h_{n})     & D(h_{n - 1}) & \cdots & D(h_{1})     & D(h_{0})     \\
\end{array}} \right] ,
}
over a set of lags \eqn{\{h_{0}, h_{1}, \dots , h_{N} \},} where \eqn{D(h) = \hat{C}_{1}(h) - \hat{C}_{2}(h),}
is defined as \deqn{{\left\Vert D \right\Vert}_{HS} = \sqrt{\sum_{i,j} d_{i, j}^{2}}.}
}
\examples{
x <- seq(0, 5, by=0.1)
estCov1 <- exp(-x^2)
estCov2 <- exp(-x^2.1)
hilbert_schmidt(estCov1, estCov2)
}
