% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block_bootstrap.R
\name{bootstrap_sample}
\alias{bootstrap_sample}
\title{Block Bootstrap Sample}
\usage{
bootstrap_sample(X, l, k, boot_type = "moving")
}
\arguments{
\item{X}{A vector representing observed values of the time series.}

\item{l}{The block length considered for bootstrap.}

\item{k}{The number of blocks considered for bootstrap.}

\item{boot_type}{What type of block bootstrap should be used, either 'moving' for moving block bootstrap or 'circular' for circular block bootstrap.}
}
\value{
A vector of length \code{length(X)} whose values are a bootstrapped time series.
}
\description{
This function generates block bootstrap samples for either moving block bootstrap or circular bootstrap.
}
\details{
This function generates a block bootstrap sample for a time series \eqn{X.}
For the moving block bootstrap and circular bootstrap procedures see \link{block_bootstrap} and the included references.
}
\examples{
X <- c(1, 2, 3, 3, 2, 1)
bootstrap_sample(X, 2, 3)
}
\references{
Chapters 2.5 and 2.7 in Lahiri, S. N. (2003). Resampling Methods for Dependent Data. Springer. https://doi.org/10.1007/978-1-4757-3803-2

Künsch, H. R. (1989). The Jackknife and the Bootstrap for General Stationary Observations. The Annals of Statistics 17(3), 1217-1241. https://doi.org/10.1214/aos/1176347265

Politis, D. N. & Romano, J. P. (1991). A Circular Block-Resampling Procedure for Stationary Data. In R. LePage & L. Billard, eds, Exploring the Limits of Bootstrap, Wiley, 263-270.
}
