% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copc1.r
\name{selectCopC}
\alias{selectCopC}
\title{The selection of copula function}
\usage{
selectCopC(cop.type=c("Clayton","Gaussian","Gumbel","Joe","Frank"),
Yc,d,delta,nIS=500,jumps=NULL,MARGIN=NULL,...,intervals=NULL)
}
\arguments{
\item{cop.type}{a Kx1 vector containing the candidate copulas,
where K = length(cop.type) is the number of candidate copulas.
There are currently five available copula funcitons,
including Clayton copula, Gaussian copula, Gumbel copula, Joe copula and Frank copula.
Select each by specifying a vector consisting of at least one element from
c("Clayton","Gaussian","Gumbel","Joe","Frank").}

\item{Yc}{the Nx1 vector of observed responses
that are subject to lower detection limit.}

\item{d}{the lower detection limit.}

\item{delta}{the Nx1 vector of censoring indicator
with 1 indicating uncensored and 0 indicating left censored.}

\item{nIS}{the size for sequential importance sampling.
The default is 500.}

\item{jumps}{the Nx1 vector indicating whether
each time t is a start of a new time series, which is deemed to be
independent from the previous series.}

\item{MARGIN}{the marginal distribution of the latent time series.}

\item{...}{additional parameters for the marginal distribution of the latent time series.}

\item{intervals}{a 2xK matrix specifying
the lower and upper bound for the copula parameter of each candidate copula, where K is the number
of candidate copulas.}
}
\value{
\code{selectCopC} returns a list of components including
\item{paras}{a Kx1 vector containing the estimated copula parameters for each candidate copula.}
\item{likelihoods}{a Kx1 vector containing
the negative log-likelihood value corresponding to the estimated copula parameter
for each candidate copula.}
\item{estCop}{a list containing the estimated copula object for each candidate.}
\item{L2distance}{a Kx1 vector containing the L2 distance between each copula
with estimated copula parameter
and the empirical copula function.}
\item{Selected}{The selected copula object.}
}
\description{
Among a list of copulas, select the one that gives the estimates
closest to the empirical copula function.
}
\examples{
### Example with simulated data
set.seed(20)
Y = genLatentY("Clayton",1,30,MARGIN.inv = qt,df=3)
d = -1
Yc = pmax(d,Y)
delta = (Y>d)
selectCopC(cop.type=c("Clayton","Frank"),Yc = Yc,d = d,delta = delta,nIS=50)
### Example with water data
attach(water)
Yc = TNH3[1:30]
delta = Delta[1:30]
jumps = Indep[1:30]
set.seed(1)
intv.Gaussian = c(-1,1)
intv.Clayton = c(0,20)
intv.Frank = c(0,15)
intervals = cbind(intv.Gaussian,intv.Clayton,intv.Frank)
cop.type = c("Gaussian","Clayton","Frank")
selCopC <- selectCopC(cop.type=cop.type,Yc=Yc,d=0.02,
            delta=delta,nIS = 50,jumps=jumps,intervals=intervals)
selCopC$Selected
}
\references{
Li, F., Tang, Y. and Wang, H. (2018) Copula-based Semiparametric Analysis for Time Series Data with Detection Limits, technical report.
}
\seealso{
\code{\link{estCopC}}.
}
