% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ColemanCollectivityConcept.R
\name{colemanCollectivityPowerIndex}
\alias{colemanCollectivityPowerIndex}
\title{Compute Coleman Power index of a Collectivity to Act}
\usage{
colemanCollectivityPowerIndex(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
Coleman Power index of a Collectivity to Act for specified simple game
}
\description{
Calculates the Coleman Power index of a 
Collectivity to Act 
for a specified simple TU game.
Note that in general the Coleman Power index of a 
Collectivity to Act is not an efficient vector, 
i.e. the sum of its entries is not always 1. 
Note also that the the Coleman Power index of a 
Collectivity to Act is identical for each player, i.e. the 
result for each player is the number of winning coalitions divided by 2^n.
Hence no drawing routine for the Coleman Power index 
of a Collectivity to Act is provided.
}
\examples{
library(CoopGame) 
v=c(0,0,0,1,1,0,1)
colemanCollectivityPowerIndex(v) 

}
\references{
Coleman J.S. (1971) "Control of collectivities and the power of a collectivity to act". In: Liberman B. (Ed.), Social Choice, Gordon and Breach, pp. 269--300

De Keijzer B. (2008) "A survey on the computation of power indices", Technical Report, Delft University of Technology, p. 18

Bertini C. and Stach I. (2011) "Coleman index", Encyclopedia of Power, SAGE Publications, p. 117--119
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
