% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SG.R
\name{SG}
\alias{SG}
\title{SG: Sison and Glaz Method for Simultaneous Confidence Intervals}
\usage{
SG(x, alpha)
}
\arguments{
\item{x}{Integer vector of observed cell counts corresponding to a
categorical dataset. All entries must be non-negative.}

\item{alpha}{Desired statistical significance level.}
}
\value{
Prints the original and adjusted confidence intervals for each
category, along with the volume (product of interval widths).
}
\description{
Computes simultaneous confidence intervals for multinomial proportions
using the Sison and Glaz (1995) method. The function implements the
truncated Poisson approach, approximates the required probabilities via
Edgeworth expansion, and determines the limits that ensure the overall
confidence level (1 - alpha).
}
\details{
This function implements the simultaneous confidence interval construction
proposed by Sison and Glaz (1995). It is based on a truncated Poisson model
with factorial and central moment calculations, Edgeworth expansion for
probability approximation, and adjustment of limits to ensure they remain
within the [0,1] range.

The computed volume represents the product of the widths of all confidence
intervals and serves as a measure of the overall uncertainty.
}
\examples{
y <- c(44, 55, 43, 32, 67, 78)
z <- 0.05
SG(y, z)

}
\references{
Sison, C. P., and Glaz, J. (1995).
*Simultaneous Confidence Intervals and Sample Size Determination for Multinomial Proportions.*
Journal of the American Statistical Association, **90**, 366–369.
}
\seealso{
\code{\link{BMDE}}, \code{\link{WALD}}, \code{\link{GM}}
}
\author{
Dr. M. Subbiah
}
