% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratifyByConcept.R
\name{stratifyByConcept}
\alias{stratifyByConcept}
\title{Stratify a codelist by the concepts included within it.}
\usage{
stratifyByConcept(
  x,
  cdm,
  nameStyle = "{codelist_name}_{concept}",
  keepOriginal = FALSE
)
}
\arguments{
\item{x}{A codelist.}

\item{cdm}{A cdm reference to an OMOP CDM dataset. If data is held within a
database, the vocabulary tables should be in the same schema as the clinical
tables (person, observation period, and so on).}

\item{nameStyle}{Naming of the new codelists, use \code{{codelist_name}} to
include the codelist name and \code{{concept}} to include the concept name.}

\item{keepOriginal}{Whether to keep the original codelist (TRUE) or just return
the stratified ones (FALSE).}
}
\value{
The codelist or a codelist with details with the required
stratifications, as different elements of the list.
}
\description{
Stratify a codelist by the concepts included within it.
}
\examples{
\donttest{
library(CodelistGenerator)

cdm <- mockVocabRef()

codes <- newCodelist(list("concepts" = c(20L, 21L)))

new_codes <- stratifyByConcept(x = codes,
                               cdm = cdm,
                               keepOriginal = TRUE)

new_codes
}
}
