% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoNI_functions.R
\name{getVertexsPerEdgeFeature}
\alias{getVertexsPerEdgeFeature}
\title{Vertex Class profile per edge feature (one treatment)}
\usage{
getVertexsPerEdgeFeature(
  CompTreatTable,
  Annotation,
  chunks = 5,
  treat = NULL,
  small = FALSE,
  ggrep = TRUE,
  xlb = "Gene",
  onlyTable = FALSE,
  szTitle = 12,
  szaxisTxt = 12,
  szaxisTitle = 12,
  ...
)
}
\arguments{
\item{CompTreatTable}{Output of Compare_VertexClasses_sharedEdgeFeatures}

\item{Annotation}{Data frame that includes the rgb colors for every class. The column 'class' (or 'Class') has to be present and also the column 'ColorRgb'}

\item{chunks}{To avoid a non readable dense plot the results can be spitted in multiple plots}

\item{treat}{Specify the treatment for which the plot will be created. It should be one of the two treatments in the output of Compare_VertexClasses_sharedEdgeFeatures}

\item{small}{logical. If only a few edge features are in the input set as TRUE. A single plot will be created}

\item{ggrep}{logical. If TRUE includes ggrepel labels for every bar}

\item{xlb}{x-axis label}

\item{onlyTable}{logical. If TRUE a table is returned instead of a plot}

\item{szTitle}{Size title}

\item{szaxisTxt}{Size axis text}

\item{szaxisTitle}{Size axis title}

\item{...}{Other parameters for inner functions, mainly ggplot2 visual parameters}
}
\value{
A list of ggplot objects to create different barplots. The barplots show the number of vertex features per class for every shared
edge feature between two treatments. The barplots restrict to one of the compared treatments. An alternative output
is a data.frame with the number of vertex features per class and edge feature (onlyTable=TRUE)
}
\description{
This function creates a barplot or barplots showing the number of vertex features per class for every shared edge feature between two treatments
}
\examples{
data(VertexClassesSharedGenes_HFDvsChow)
data(MetColorTable)
#Note: No differences in example as all the Output of CoNI was kept
getVertexsPerEdgeFeature(CompTreatTable = VertexClassesSharedGenes_HFDvsChow,
                         Annotation = MetColorTable,
                         chunks = 2,
                         treat = "HFD")
}
