% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_generic.R
\name{BMD}
\alias{BMD}
\title{Benchmark dose}
\usage{
BMD(level, risk, x, alpha=0.05)
}
\arguments{
\item{level}{dose level of interest.}

\item{risk}{\code{summary.risk$mcmc.risk} from the output of \code{add.risk} function.}

\item{x}{numeric vector for the covariate relative to the dose of exposure used in \code{comire.gibbs}.}

\item{alpha}{level of the credible bands.}
}
\value{
A dataframe containing as variables:
\itemize{
\item{\code{q}}{ the dose level of interest.}
\item{\code{BMD}}{ the benchmark dose.}
\item{\code{low}}{ lower credible limit.}
\item{\code{upp}}{ upper credible limit.}
\item{\code{BMDL}}{ a more conservative benchmark dose.}
}
}
\description{
Benchmark dose associated to a particular risk
}
\examples{
{
data(CPP)
attach(CPP)

n <- NROW(CPP)
J <- H <- 10

premature <- as.numeric(gestage<=37)

mcmc <- list(nrep=5000, nb=2000, thin=5, ndisplay=4)

## too few iterations to be meaningful. see below for safer and more comprehensive results

mcmc <- list(nrep=10, nb=2, thin=1, ndisplay=4) 

prior <- list(mu.theta=mean(gestage), k.theta=10, eta=rep(1, J)/J, 
              alpha=rep(1,H)/H, a=2, b=2, J=J, H=H)
              
fit.dummy <- comire.gibbs(gestage, dde, family="continuous", 
                     mcmc=mcmc, prior=prior, seed=1, max.x=180)
                     
risk.data <- add.risk(y = gestage, x = dde, fit = fit.dummy, mcmc = mcmc, 
    a = 37, x.grid = seq(0, max(dde), length = 100))
bmd.data <- BMD(seq(0,.20, length=50), risk.data$mcmc.risk, 
x=seq(0,max(dde), length=100), alpha=0.05)
bmd.plot(bmd.data)       
                     
\donttest{
## safer procedure with more iterations (it may take some time)

mcmc <- list(nrep=5000, nb=2000, thin=5, ndisplay=4)

## Fit the model for continuous y 

prior <- list(mu.theta=mean(gestage), k.theta=10, eta=rep(1, J)/J, 
              alpha=rep(1,H)/H, a=2, b=2, J=J, H=H)
              
fit <- comire.gibbs(gestage, dde, family="continuous", 
                     mcmc=mcmc, prior=prior, seed=5, max.x=180)


risk.data <- add.risk(y = gestage, x = dde, fit = fit, mcmc = mcmc,
a = 37, x.grid = seq(0, max(dde), length = 100))
bmd.data <- BMD(seq(0,.20, length=50), risk.data$mcmc.risk, 
x=seq(0,max(dde), length=100), alpha=0.05)
bmd.plot(bmd.data)       

}
}
}
\author{
Antonio Canale
}
