% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.clustvar.R
\name{plot.clustvar}
\alias{plot.clustvar}
\title{Plot loadings in each cluster.}
\usage{
\method{plot}{clustvar}(x, ...)
}
\arguments{
\item{x}{an object of class \code{clustvar} obtained with \code{cutreevar} or \code{kmeansvar}.}

\item{\dots}{Further arguments to be passed to or from other methods. They
are ignored in this function.}
}
\value{
\item{coord.quanti}{coordinates of quantitative variables belonging to cluster k on the synthetic
 variable associate to the same cluster k}
\item{coord.levels}{coordinates of levels of categorical variables belonging to cluster k on the synthetic
 variable associate to the same cluster k}
}
\description{
Plot dotchart with the "loadings" of the variables in each cluster. The loading of a
numerical variable is the correlation between this variables and the synthetic variable of its cluster.
The loading of the level of a categorical variable is the mean value of the synthetic variable
of the cluster on observations having this level.
}
\examples{
data(wine)
X.quanti <- PCAmixdata::splitmix(wine)$X.quanti
X.quali <- PCAmixdata::splitmix(wine)$X.quali
tree <- hclustvar(X.quanti,X.quali)
tree.cut<-cutreevar(tree,6)

#plot of scores on synthetic variables
res.plot <- plot(tree.cut)
res.plot$coord.quanti
res.plot$coord.levels
}
