% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wtd.stat.ang.R
\name{wtd.stat.ang}
\alias{wtd.stat.ang}
\title{Weighted extrinsic mean direction and mean resultant length}
\usage{
wtd.stat.ang(data, w)
}
\arguments{
\item{data}{angular data whose elements are in \eqn{[0, 2\pi)}}

\item{w}{numeric vector whose each element is non-negative and
\code{sum(w) == 1}. Moreover, the length of \code{w} is the same with
\code{nrow(data)}.}
}
\value{
list which is consisting of the following components:

  \code{Mean} weighted extrinsic mean direction

  \code{R} mean resultant length
}
\description{
\code{wtd.stat.ang} computes weighted extrinsic mean direction and
  mean resultant length.
}
\examples{
data <- matrix(c(pi/3, pi/3, pi/2,
                 pi, pi/4, pi/2,
                 0, pi/3, pi/6),
               ncol = 3, byrow = TRUE)
w <- c(0.3, 0.3, 0.4)
wtd.stat.ang(data, w)
}
\references{
Jung, S., Park, K., & Kim, B. (2021). Clustering on the torus by conformal prediction. \emph{The Annals of Applied Statistics}, 15(4), 1583-1603.
}
