% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ang.dist.R
\name{ang.dist}
\alias{ang.dist}
\title{Angular distance}
\usage{
ang.dist(x, y)
}
\arguments{
\item{x, y}{angular data(both scalar or vector) whose elements are in \eqn{[0, 2\pi)}}
}
\value{
angular data (scalar or vector) whose elements are in \eqn{[0, 2\pi)}
}
\description{
\code{ang.dist} computes element-wise angular distance between
 two angular values in \eqn{[0,2\pi)}.
}
\examples{
x <- c(pi/3, 0)
y <- c(pi/4, pi/2)

ang.dist(x, y)
}
\references{
Jung, S., Park, K., & Kim, B. (2021). Clustering on the torus by conformal prediction. \emph{The Annals of Applied Statistics}, 15(4), 1583-1603.
}
