% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netplot.R
\name{netplot_ClusTCR2}
\alias{netplot_ClusTCR2}
\title{Code for displaying the network.}
\usage{
netplot_ClusTCR2(
  ClusTCR,
  filter_plot = 0,
  Clust_selected = 1,
  selected_col = "purple",
  selected_text_col = "black",
  selected_text_size = 3,
  non_selected_text_size = 2,
  Clust_column_name = "cluster",
  label = c("Name", "cluster", "CDR3", "V_gene", "Len"),
  non_selected_col = "grey80",
  non_selected_text_col = "grey40",
  alpha_selected = 1,
  alpha_non_selected = 0.5,
  colour = "color_test",
  all.colour = "default"
)
}
\arguments{
\item{ClusTCR}{File produced from mcl_cluster}

\item{filter_plot}{Filter's plot to remove connects grater than # e.g. 2 = 3 or more connections.}

\item{Clust_selected}{Select which cluster to label.}

\item{selected_col}{Color of selected cluster (Default = purple)}

\item{selected_text_col}{Color of selected cluster text (Default = black)}

\item{selected_text_size}{Text size of selected cluster (Default = 3)}

\item{non_selected_text_size}{Text size of non-selected clusters (Default = 2)}

\item{Clust_column_name}{Name of clustering column from mcl_cluster file e.g. cluster (Re-numbering the original_cluster), Original_cluster, Clust_size_order (Based on cluster size e.g. number of nodes)}

\item{label}{Name to display on cluster: Name (CDR3_V_gene_Cluster), cluster, CDR3, V_gene, Len (length of CDR3 sequence), CDR3_selected, V_gene_selected, Name_selected,cluster_selected, (_selected only prints names of the chosen cluster), None}

\item{non_selected_col}{Color of selected cluster (Default = grey80)}

\item{non_selected_text_col}{Color of selected clusters text (Default = grey40)}

\item{alpha_selected}{Transparency of selected cluster (default = 1)}

\item{alpha_non_selected}{Transparency of non-selected clusters (default = 0.5)}

\item{colour}{Colour selected = "color_test" or all = "color_all"}

\item{all.colour}{Colours all points by: rainbow, random, heat.colors, terrain.colors, topo.colors, hcl.colors and default}
}
\value{
A ggplot object displaying the network plot.
}
\description{
Code for displaying the network.
}
\examples{
# Example usage of mcl_cluster function with a stored file
example_file <- read.csv(system.file("extdata", "my_data.csv",package = "ClusTCR2"))
# Perform clustering using mcl_cluster function
step1 <- ClusTCR(example_file,allele = FALSE)
# perform mcl
step2 <- mcl_cluster(step1)
# print the clustering plot after performing step 1 and step 2
print(netplot_ClusTCR2(step2, label = "Name_selected"))
}
