% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptiNum.R
\name{OptiNum}
\alias{OptiNum}
\title{Finding an optimal number of clusters}
\source{
Malika Charrad, Nadia Ghazzali, Veronique Boiteau, Azam Niknafs (2014). NbClust: An R Package for Determining the Relevant Number of Clusters in a Data Set. Journal of Statistical Software, 61(6), 1-36. URL http://www.jstatsoft.org/v61/i06/.
}
\usage{
OptiNum(
  formula,
  group,
  data,
  index = c("silhouette", "ch", "db"),
  max_clust = 10,
  base_val = FALSE
)
}
\arguments{
\item{formula}{A two-sided \code{\link[stats]{formula}} object, with a numeric, clustering variable (Y) on the left of a ~ separator and the time (numeric) variable on the right. Time is measured from the start of the follow-up period (baseline).}

\item{group}{A grouping factor variable (vector), i.e. single identifier for each individual (trajectory).}

\item{data}{A data frame containing the variables named in \code{formula} and \code{group} arguments.}

\item{index}{String vector of indices to be computed. Default is c("silhouette", "ch", "db"). See NbClust package for available indices and their description.}

\item{max_clust}{An integer, positive number (scalar) defining the maximum number of clusters to check. Default value of this argument is 10 or maximum number of individuals.}

\item{base_val}{Indicates whether include a value at zero time point as an additional clustering variable. Default is \emph{FALSE} and the standard number (7) of clustering parameters is used.}
}
\value{
Determine the optimal number of clusters, returns graphical output (red dot in plot indicates the recommended number of clusters according to that index) and table with indices.
}
\description{
This function finds optimal number of clusters based on evaluation criteria (indices) available from the NbClust package.
}
\examples{
set.seed(123)
data <- GeneratePanel(n = 100, Param = ParamLinear, NbVisit = 10)
OptiNum(data = data, formula = Y ~ Time, group = "ID")

}
\keyword{CluMP}
